
Module nelist Import set nat case;

(* --------------------------------------------------------------------------------
  non empty lists
*)

Inductive [nelist : SET]
Parameters [S : SET]
Constructors [base' : S -> nelist] [necons' : S -> nelist -> nelist];
Discharge S;

[S | SET];

[    base  : S -> (nelist S)
          = base' S
]
[    necons : S -> (nelist S) -> (nelist S)
          = necons' S
];

[    nelist_rec [T|TYPE]
            = nelist_elim S (nelist S)\T
            : ({x:S}T) -> ({x:S}{l:nelist S}{ih:T}T) -> (nelist S) -> T 
]
[    nelist_iter [T|TYPE][f0:{x:S}T][f1:{x:S}{ih:T}T]
            = nelist_rec f0 ([x:S](nelist S)\f1 x)
            :  (nelist S) -> T
]
[    nelist_ind [P:(nelist S) -> Prop]
            = nelist_elim S P
            : ({x:S}P (base x)) ->
              ({x:S}{l:nelist S}{ih:P l} P (necons x l)) ->
              {l:nelist S} P l
];

DischargeKeep S;

Goal {T,U|SET}
     {psi:(nelist T)->(nelist U)->TYPE}
     ({t:T}{u:U}psi (base t) (base u)) ->
     ({t:T}{u:U}{m:nelist U}(psi (base t) m) -> psi (base t) (necons u m)) ->
     ({t:T}{l:nelist T}({m:nelist U}psi l m) -> {u:U}psi (necons t l) (base u)) ->
     ({t:T}{l:nelist T}({m:nelist U}psi l m) ->
                     {u:U}{m:nelist U}(psi (necons t l) m) ->
                     psi (necons t l) (necons u m)) ->
     {l:nelist T}{m:nelist U} psi l m;
  Intros _______;
  Refine nelist_elim ? [l:nelist T]{m:nelist U}psi l m;
  intros t; Refine nelist_elim ? (psi (base t)) (H t) (H1 t);
  Intros x l ih;
  Refine nelist_elim ? (psi (necons x l)) (H2 ? ? ih) (H3 ? ? ih);
Save nelist_elim2;

[    ne_head : (nelist S) -> S
            = nelist_iter (Id|S) ([x,ih:S]x)
]
[    ne_tail : (nelist S) -> (nelist S)
            = nelist_rec (base|S) ([x:S][l:nelist S][ih:nelist S] l)
]
[    ne_nth [l:nelist S][n:nat] : S
           = nat_rec ne_head ([_:nat][ih:(nelist S)->S][l:nelist S] ih (ne_tail l)) n l
];

Discharge S;

(* --------------------------------------------------------------------------------
*)

[A | Set];

[EqneList : rel (nelist A.el)
  = nelist_elim2 (A.el.nelist\A.el.nelist\Prop)
               (Eq|A)
               ([t,u:A.el][m:nelist A.el][ih_m:Prop] absurd)
               ([t:A.el][l:nelist A.el][ih_l:(nelist A.el)->Prop][u:el A] absurd)
               ([t:A.el][l:nelist A.el][ih_l:(nelist A.el)->Prop]
                [u:A.el][m:nelist A.el][ih_m:Prop] and (Eq t u) (ih_l m))
];

Goal reflexive EqneList;
  Refine nelist_ind ([l:nelist A.el] EqneList l l);
  Refine Eq_refl;
  intros __; Refine pair ?.Eq_refl;
Save EqneList_refl;

Goal symmetric EqneList;
  Refine nelist_elim2 [l,m:nelist A.el] (EqneList l m) -> EqneList m l;
  Refine Eq_sym;
  intros ____; Refine Id;
  intros ____; Refine Id;
  intros; Refine pair H2.fst.Eq_sym (H ? H2.snd);
Save EqneList_sym;

Goal transitive EqneList;
  Refine nelist_elim2 [a,b:nelist A.el]
               {c:nelist A.el} (EqneList a b) -> (EqneList b c) -> EqneList a c;
  
  intros a b m _;
    Refine nelist_ind [c:nelist A.el] (EqneList (base b) c) -> EqneList (base a) c;
    intros c; Refine Eq_trans ? H;
    intros ___; Refine Id;
  intros; Refine H1;
  intros; Refine H1;
  intros a k ih_a b l ih_b m _;
    Refine nelist_ind [c:nelist A.el]
                        (EqneList (necons b l) c) -> EqneList (necons a k) c;
    intros _; Refine Id;
    intros c ___; Refine pair;
    Refine Eq_trans ? H.fst H1.fst;
    Refine ih_a ? ? H.snd H1.snd;
Save EqneList_trans;

DischargeKeep A;

[neList [A:Set] = SetI (EqneList_refl|A) (EqneList_sym|A) (EqneList_trans|A)];

Goal extensional (ne_head|A.el : (neList A).el -> A.el);
  Refine nelist_elim2 [l,m:(neList A).el] (Eq l m) -> Eq (ne_head l) (ne_head m);
  intros __; Refine Id;
  intros; Refine H1;
  intros; Refine H1;
  intros; Refine H2.fst;
Save ne_head_exten;

Goal extensional (ne_tail|A.el : (neList A).el -> (neList A).el);
  Refine nelist_elim2 [l,l':(neList A).el]
                          (Eq l l') -> Eq|(neList A) (ne_tail l) (ne_tail l');
  intros __; Refine Id;
  intros; Refine H1;
  intros; Refine H1;
  intros; Refine snd H2;
Save ne_tail_exten;

Goal extensional2 (ne_nth|A.el : (neList A).el -> Nat.el -> A.el);
  Intros l l' _ x x' _;
  Qrepl H1;
  Refine nat_ind [x':nat]
              {l,l':(neList A).el} (Eq l l') -> Eq (ne_nth l x') (ne_nth l' x');
  Refine ne_head_exten;
  intros; Refine ih; Refine ne_tail_exten H2;
  Refine H;
Save ne_nth_exten;

Discharge A;
