
Module case Import Q set;

(* Module which defines case distinction. *)

(*
   First we defines a selector 'select' such that
   if we know P \/ P' for some propositions P and P'
   we have

     select x y ==> x     if P
     select x y ==> y     if P'

  To do so, we define the inductive or. As a result the ordinary or becomes strong.

*)

Inductive [Or : Prop]
Parameters [P,P' : Prop]
Constructors [Inl : P -> Or] [Inr : P' -> Or]
ElimOver SET;
Discharge P;

[P,P' | Prop] [z : P \/ P'];

Goal {T|SET} T -> T -> T;
  intros T x y;
  Refine Or_elim ?? (Or P P')\T;
  intros; Refine x;
  intros; Refine y;
  orE z; Refine Inl; Refine Inr;
Save select;

Goal {A:Set} extensional2 (select|A.el);
  Intros;
  Refine Or_elim ?? ([z:Or P P'] Eq (Or_elim ?? ((Or P P')\el A) (P\x ) (P'\y)  z)
                                    (Or_elim ?? ((Or P P')\el A) (P\x') (P'\y') z));
  intros; Refine H;
  intros; Refine H1;
Save select_exten;

Goal Select : {A:Set} BFun A;
  intros;
  Refine Fun2I;
  Refine +1 select_exten;
Save;

Discharge z;

(*
   Prove some basic properties:

      (P->(phi x)) -> (~P->(phi y)) -> phi (select z x y)

       P -> (select x y) = x
      ~P -> (select x y) = y

   if P -> ~P -> x = y
*)

[z | P \/ P'];

Goal {T|SET} {phi:T->SET} {x,y|T} (P -> phi x) -> (P' -> phi y) -> phi (select z x y);
  intros;
  Refine Or_elim ?? ([z:Or P P'] phi (Or_elim ?? ((Or P P')\T) (P\x) (P'\y) z));
  Refine H; Refine H1;
Save select_lemma;

[A | Set] [x,y | el A] [z' : P -> P' -> Eq x y];

Goal select_left : P -> Eq (select z x y) x;
  intros;
  Refine select_lemma ([z:el A] Eq z x);
  intros; Refine Eq_refl;
  intros; Refine (z' H H1).Eq_sym;
Save;

Goal select_right : P' -> Eq (select z x y) y;
  intros;
  Refine select_lemma ([z:el A] Eq z y);
  intros; Refine z' H1 H;
  intros; Refine Eq_refl;
Save;

Discharge P;

(*
   Define case distinction 'if' such  that

     (if x y a b) = a     if x = y
     (if x y a b) = b     otherwise

   assuming the discreteness of the set to which x and y belong.
*)

Goal if : {A|Set} (Discrete A) -> {T|SET} A.el -> A.el -> T -> T -> T;
  intros A A_discr _ x y;
  Refine select (A_discr x y);
Save;

[A | Set] [A_discr | Discrete A]
[B | Set] [B_discr | Discrete B]
[C | Set];

Goal if_true : {x,y|el A} (Eq x y) -> {a,b:el C} Eq (if A_discr x y a b) a;
  intros;
  Refine select_left;
  intros; Refine H2 H1;
  Refine H;
Save;

Goal if_false : {x,y|el A} ~(Eq x y) -> {a,b:el C} Eq (if A_discr x y a b) b;
  intros;
  Refine select_right;
  intros; Refine H2 H1;
  Refine H;
Save;

DischargeKeep A;

Goal {x,y|el A} {x',y'|el B} ((Eq x y) -> (Eq x' y')) -> ((Eq x' y') -> (Eq x y)) ->
     {a,a'|el C} (Eq a a') ->
     {b,b'|el C} (Eq b b') ->
     Eq (if A_discr x y a b) (if B_discr x' y' a' b');
  intros;
  orE A_discr x y;
  intros;
    Refine Eq_trans a; Refine if_true H4;
    Refine Eq_trans a'; Refine H2;
    Refine Eq_sym; Refine if_true (H H4);
  intros;
    Refine Eq_trans b; Refine if_false H4;
    Refine Eq_trans b'; Refine H3;
    Refine Eq_sym; Refine if_false;
    Intros _; Refine H4 (H1 H5);
Save if_exten;

(* Prove some properties of if. *)

Goal {x,y:el A} {z:el B} Eq (if A_discr x y z z) z;
  intros;
  orE A_discr x y;
  intros; Refine if_true H;
  intros; Refine if_false H;
Save if_ident;

Goal {f:op B.el} {x,y:el A}{a,b:el B}
     Eq (if A_discr x y (f a) (f b)) (f (if A_discr x y a b));
  intros;
  orE A_discr x y;
  intros;
    Refine Eq_trans (f a);
      Refine if_true H;
    Refine select_lemma ([t:el B] Eq (f a) (f t));
      intros; Refine Eq_refl;
      intros; Refine H1 H;
  intros;
    Refine Eq_trans (f b);
      Refine if_false H;
    Refine select_lemma ([t:el B] Eq (f b) (f t));
      intros; Refine H H1;
      intros; Refine Eq_refl;
Save if_distrib;

Discharge A;
