
Module Semantics Import map Syntax;

(* =========================================================================
   Semantics
*)

[     Structure [sig:Signature] : TYPE
          = <A:Set> ({c:FuncSymb sig} nFunc A (FuncArity c)) #
                    ({p:PredSymb sig} nPred A (PredArity p))
]
[     Axioms [sig:Signature] : TYPE
          = (Structure sig) -> Prop
]
[     Model [sig|Signature] [ax:Axioms sig] : TYPE
          = <str:Structure sig> ax str
];

[sig | Signature] [ax | Axioms sig] [M : Model ax];

[     structure : Structure sig
          = M.1
]
[     axioms : ax structure
          = M.2
]
[     car : Set
          = structure.1
]
[     obj : SET
          = el car
]
[     intFunc : {c:FuncSymb sig} nFunc car (FuncArity c)
          = structure.2.1
]
[     intCons : {c:FuncSymb sig} arrow obj obj (FuncArity c)
          = [c:FuncSymb sig] (intFunc c).apn
]
[     intPred : {p:PredSymb sig} nPred car (PredArity p)
          = structure.2.2
];

[     Structure_intro [A|Set] [intFunc:{c:FuncSymb sig} nFunc A (FuncArity c)]
                              [intPred:{p:PredSymb sig} nPred A (PredArity p)]
          : Structure sig
          = (A, intFunc, intPred : Structure sig)
]
[     Axioms_intro [z : {A|Set}({c:FuncSymb sig} nFunc A (FuncArity c)) -> 
                               ({p:PredSymb sig} nPred A (PredArity p)) -> Prop]
          : Axioms sig
          = [str:Structure sig] z str.2.1 str.2.2
]
[     Model_intro [A|Set] [intCons:{c:FuncSymb sig} nFunc A (FuncArity c)]
                          [intPred:{p:PredSymb sig} nPred A (PredArity p)]
                          [axioms : ax (Structure_intro intCons intPred)]
          : Model ax
          = (Structure_intro intCons intPred, axioms : Model ax)
];

[     Assignment : Set
          = neList car
];

(* Define the interpretation of tuples of terms with respect to an
   assignment. *)

Goal int_n : {n|nat} Assignment.el -> (Terms sig n).el -> (Product car n).el;
  intros m rho;
  Refine terms_elim ? [n:nat](Terms sig n).el\(Product car n).el;
  intros n; Refine tuple (ne_nth rho n) star;
  intros c t ih; Refine tuple (c.intFunc.app ih) star;
  Refine star;
  intros n t1 tn ih1 ihn; Refine tuple ih1.first ihn;
Save;

(* Show int_n preserves equality. *)

Goal {n|nat} extensional2 (int_n|n);
  Intros m rho rho' _ v w _;
  Qrepl H1;
  Refine terms_elim sig [n:nat][w:terms sig n] Eq (int_n rho w) (int_n rho' w);
  intros x; Refine pair ? ?.Eq_refl;
    Refine ne_nth_exten H ?.Eq_refl;
  intros c t ih; Refine pair ? ?.Eq_refl;
    Equiv Eq (c.intFunc.app (int_n rho t)) (c.intFunc.app (int_n rho' t));
    Refine extp ? ih;
  Refine Eq_refl;
  intros; Refine pair x1_ih.fst x2_ih;
Save int_n_exten;

(* Define the interpretation of terms with respect to an assignment. *)

Goal int : {rho:Assignment.el} (Term sig).el -> obj;
  intros; Refine (int_n rho H).first;
Save;

Goal {t,t'|(Term sig).el}{rho,rho'|Assignment.el}
     (Eq (int rho t) (int rho' t')) -> Eq (int_n rho t) (int_n rho' t');
  intros; Refine pair;
  Refine H;
  Refine UnitSet_trivial;
Save int_int_n;

Goal {t,t'|(Term sig).el}{rho,rho'|Assignment.el}
     (Eq (int_n rho t) (int_n rho' t')) -> Eq (int rho t) (int rho' t');
  intros ____;
  Refine fst;
Save int_n_int;

(* Show int preserves equality. *)

Goal extensional2 int;
  Intros ______;
  Refine int_n_int;
  Refine int_n_exten H H1;
Save int_exten;

(* Prove the Compatibility lemma. *)

Goal {rho,rho':el Assignment} (Eq rho rho') ->
     {t:el (Term sig)} Eq (int rho t) (int rho' t);
  intros;
  Refine int_exten H ?.Eq_refl;
Save CompAss;

(* -------------------------------------------------------------------------
   Define the collapsing procedure.
*)

(* We prove x = y  ->  x[y:=t] = t *)

Goal {x,y|el Nat} (Eq x y) -> {t:el (Term sig)} Eq (Subst_n (TFV sig x) y t) t;
  intros;
  Refine if_true H;
Save Subst_eq;

Goal {x,y|el Nat} ~(Eq x y) -> {t:el sig.Term} Eq (Subst_n (TFV sig x) y t) (TFV sig x);
  intros;
  Refine if_false H;
Save Subst_neq;

(* We prove [VAR x] = [u]  -> [t] = [t[x:=u]] *)

Goal {x:el Nat}{t,u:el sig.Term}{rho:el Assignment}
     (Eq (int rho (sig.TFV x)) (int rho u)) ->
     (Eq (int rho t) (int rho (Subst t x u)));
  intros;
  Refine int_n_int;
  Refine terms_elim ?
     ([n:nat][t:terms sig n] Eq (int_n rho t) (int_n rho (Subst_n t x u)));
  intros z;
    Refine int_int_n;
    orE Nat_discr z x;
    intros;
      Qrepl Subst_eq H1 u; Qrepl H1; Refine H;
    intros;
      Qrepl Subst_neq H1 u; Refine Eq_refl;
  intros c t' ih; Refine pair ? ?.Eq_refl; Refine extp ? ih;
  Refine Eq_refl;
  intros ___ H1 H2; Refine pair H1.fst H2;
Save SubstitutionLemma;

(* We prove [VAR x] = [u]  ->  [t[x:=u]] = [t'[x:=u]]  -> [t] = [t'] *)

Goal {t,t'|el sig.Term}{rho|el Assignment}
     {x:el Nat}{u:el sig.Term}
     (Eq (int rho (TFV sig x)) (int rho u)) ->
     (Eq (int rho (Subst t x u)) (int rho (Subst t' x u))) ->
     (Eq (int rho t) (int rho t'));
  intros;
  Refine Eq_trans (int rho (Subst t x u));
    Refine SubstitutionLemma ???? H;
  Refine Eq_trans (int rho (Subst t' x u));
    Refine H1;
  Refine Eq_sym;
  Refine SubstitutionLemma ???? H;
Save Unify;

Discharge sig;
