
Module Poly_homo Import Poly;

[IMN : indexMonoid];

[R,R' | Ring]

  $[PolyR  : Ring = PolyRing IMN R]
  $[PolyR' : Ring = PolyRing IMN R'];
  $[Poly   : Set  = Polyn IMN R]
  $[Poly'  : Set  = Polyn IMN R'];

  $[CoefP  : Fun2 Poly  IMN.car R.car  = CoefPoly IMN R ]
  $[CoefP' : Fun2 Poly' IMN.car R'.car = CoefPoly IMN R'];

[h : Homomorphism R.applGroup R'.applGroup]

  $[f  : Fun R.car R'.car = Homo_f h]
  $[fP : Fun Poly Poly'   = MapGrP IMN h];

Goal {x,y:el Poly}
     Eq (fP.ap (PolyR.PlusRg.ap2 x y)) (PolyR'.PlusRg.ap2 (fP.ap x) (fP.ap y));
  Intros ___;
  Refine Eq_trans (f.ap (CoefP.ap2 (PolyR.PlusRg.ap2 x y) i));
    Refine MapGrP_distrib;
  Refine Eq_trans (f.ap (R.PlusRg.ap2 (CoefP.ap2 x i) (CoefP.ap2 y i)));
    Refine exten; Refine CoefPoly_plus;
  Refine Eq_trans (R'.PlusRg.ap2 (f.ap (CoefP.ap2 x i)) (f.ap (CoefP.ap2 y i)));
    Refine HomoGr_times h;
  Refine Eq_sym; 
  Refine Eq_trans (R'.PlusRg.ap2 (CoefP'.ap2 (fP.ap x) i) (CoefP'.ap2 (fP.ap y) i));
    Refine CoefPoly_plus;
  Refine exten2;
  Refine MapGrP_distrib; Refine MapGrP_distrib;
Save MapGrP_plus;

Goal MapGrP_homo : Homomorphism PolyR.applGroup PolyR'.applGroup;
  Refine HomomorphismGr_intro;
  Refine MapGrP ? h;
  Refine MapGrP_plus;
Save;

Goal Eq (fP.ap (ZeroPoly IMN R)) (ZeroPoly IMN R');
  Refine MapGrP_homo.HomoGr_one;
Save MapGrP_zero;

Goal {x:el Poly} Eq (fP.ap (PolyR.NegRg.ap x)) (PolyR'.NegRg.ap (fP.ap x));
  Refine MapGrP_homo.HomoGr_inv;
Save MapGrP_neg;

Goal {x:obj R}
     Eq (fP.ap ((ConstPoly IMN R).ap x)) ((ConstPoly IMN R').ap (f.ap x));
  intros;
  Refine exten2 (PlusMP IMN R') ?.Eq_refl;
  Refine MapGrP_zero;
Save MapGrP_const;

Discharge h;

[     NegPoly_homoGr : Endomorphism PolyR.applGroup
          = NegRg_homoGr PolyR
];

Goal {h:Homomorphism R.applGroup R.applGroup}
     (Involutive h.Homo_f) -> Involutive (MapGrP IMN h);
  intros;
  Refine Polyn_ind ?? [x:el Poly] Eq ((MapGrP IMN h).ap ((MapGrP IMN h).ap x)) x;
  Refine Eq_refl;
  intros t x ih; Refine exten2 (PlusMP IMN R) ? ih;
  Refine eq_Monomial_intro;
  Refine H; Refine Eq_refl;
Save MapGrP_invol;

Discharge R;

(* --------------------------------------------------------------------------------
*)

[R,R' | Ring]
  $[PolyR = PolyRing IMN R] $[PolyR' = PolyRing IMN R'];

  $[CoefP  : Fun2 PolyR.car IMN.car R.car = CoefPoly IMN R];
  $[CoefP' : Fun2 PolyR'.car IMN.car R'.car = CoefPoly IMN R'];

[h : Homomorphism R R']
$[f : Fun R.car R'.car = Homo_f h];

[     MapRgP : Fun (Polyn IMN R) (Polyn IMN R')
          = MapGrP IMN h.HomoRg_Gr
]
[     MapRgM : Fun (Monomial IMN R) (Monomial IMN R')
          = MapM IMN f
];

Goal {P:el (Polyn IMN R)} {i:obj IMN}
     Eq (CoefP'.ap2 (MapRgP.ap P) i) (f.ap (CoefP.ap2 P i));
  Refine MapGrP_distrib IMN h.HomoRg_Gr;
Save MapRgP_distrib;

Goal {x,y:obj PolyR}
     Eq (MapRgP.ap (PolyR.PlusRg.ap2 x y))
        (PolyR'.PlusRg.ap2 (MapRgP.ap x) (MapRgP.ap y));
  Refine MapGrP_plus h.HomoRg_Gr;
Save MapRgP_plus;

Goal Eq (MapRgP.ap PolyR.OneRg) PolyR'.OneRg;
  Refine exten2 (PlusMP IMN R');
  Refine +1 Eq_refl;
  Refine eq_Monomial_intro; Refine +1 Eq_refl;
  Refine HomoRg_one h;
Save MapRgP_one;

Goal {t,u:el (Monomial IMN R)}
     Eq (MapRgM.ap ((TimesMon IMN R).ap2 t u))
        ((TimesMon IMN R').ap2 (MapRgM.ap t) (MapRgM.ap u));
  intros;
  Refine eq_Monomial_intro; Refine +1 Eq_refl;
  Refine HomoRg_times h;
Save MapM_times;

Goal {t:el (Monomial IMN R)} {g:obj PolyR}
     Eq (MapRgP.ap ((TimesMP IMN R).ap2 t g))
        ((TimesMP IMN R').ap2 (MapRgM.ap t) (MapRgP.ap g));
  intros _;
  Refine list_ind [g:obj PolyR]
     Eq (MapRgP.ap ((TimesMP IMN R).ap2 t g))
        ((TimesMP IMN R').ap2 (MapRgM.ap t) (MapRgP.ap g));
  Refine Eq_refl;
  intros u g ih;
  Refine exten2 (PlusMP IMN R') ? ih;
  Refine MapM_times;
Save MapRgMP_times;

Goal {x,y:obj PolyR}
     Eq (MapRgP.ap (PolyR.TimesRg.ap2 x y))
        (PolyR'.TimesRg.ap2 (MapRgP.ap x) (MapRgP.ap y));
  intros;
  Refine list_ind [x:obj PolyR]
     Eq (MapRgP.ap (PolyR.TimesRg.ap2 x y))
        (PolyR'.TimesRg.ap2 (MapRgP.ap x) (MapRgP.ap y));
  Refine Eq_refl;
  intros t P ih;
  Refine Eq_trans (PolyR'.PlusRg.ap2 (MapRgP.ap ((TimesMP IMN R).ap2 t y))
                                     (MapRgP.ap (PolyR.TimesRg.ap2 P y)));
    Refine MapRgP_plus;
  Refine exten2 ? ? ih;
  Refine MapRgMP_times;
Save MapRgP_times;

Goal MapRgP_homo : Homomorphism PolyR PolyR';
  Refine HomomorphismRg_intro;
  Refine MapRgP;
  Refine MapRgP_one;
  Refine MapRgP_plus;
  Refine MapRgP_times;
Save;

Goal Eq (MapRgP.ap PolyR.ZeroRg) PolyR'.ZeroRg;
  Refine MapRgP_homo.HomoRg_zero;
Save MapRgP_zero;

Goal {x:obj R}
     Eq (MapRgP.ap ((ConstPoly IMN R).ap x)) ((ConstPoly IMN R').ap (f.ap x));
  Refine MapGrP_const h.HomoRg_Gr;
Save MapRgP_const;

Goal {x:obj PolyR}
     Eq (MapRgP.ap (PolyR.NegRg.ap x)) (PolyR'.NegRg.ap (MapRgP.ap x));
  Refine MapRgP_homo.HomoRg_neg;
Save MapRgP_neg;

Goal {x:obj PolyR}{n:el Nat}
     Eq (MapRgP.ap (PolyR.PowerRg.ap2 x n)) (PolyR'.PowerRg.ap2 (MapRgP.ap x) n);
  Refine MapRgP_homo.HomoRg_power;
Save MapRgP_power;

Discharge R;

Goal {R|Ring} {h:Homomorphism R R} (Involutive h.Homo_f) -> Involutive h.MapRgP;
  intros __;
  Refine MapGrP_invol h.HomoRg_Gr;
Save MapRgP_invol;

Discharge IMN;
