
Module PolyC Import PolyR Complex Conjugate;

(* Define the polynomials in one variable over the complex numbers. *)

[     MonomialC : Set
          = Monomial1 COMPLEX_Ring
];

Goal CoefMonC : Fun MonomialC Cplx;
  Refine CoefMon1 COMPLEX_Ring;
Save;

Goal IndexMonC : Fun MonomialC Nat;
  Refine IndexMon1 COMPLEX_Ring;
Save;

Goal MonomialC_intro : Fun2 Cplx Nat MonomialC;
  Refine Monomial1_intro COMPLEX_Ring;
Save;

[     PolyRingC : Ring
          = PolyRing1 COMPLEX_Ring
]
[     PolyC : Set
          = Poly1 COMPLEX_Ring
];

Goal CoefC : Fun2 PolyC Nat Cplx;
  Refine CoefPoly1 COMPLEX_Ring;
Save;

Goal ZeroPC : el PolyC;
  Refine ZeroPoly1 COMPLEX_Ring;
Save;

Goal OnePC : el PolyC;
  Refine OnePoly1 COMPLEX_Ring;
Save;

Goal ConstPolyC : Fun Cplx PolyC;
  Refine ConstPoly1 COMPLEX_Ring;
Save;

Goal IdPolyC : el PolyC;
  Refine IdPoly1 COMPLEX_Ring;
Save;

Goal PlusPC : Fun2 PolyC PolyC PolyC;
  Refine PlusPoly1 COMPLEX_Ring;
Save;

Goal NegPC : Fun PolyC PolyC;
  Refine NegPoly1 COMPLEX_Ring;
Save;

Goal TimesPC : Fun2 PolyC PolyC PolyC;
  Refine TimesPoly1 COMPLEX_Ring;
Save;

Goal PowerPC : Fun2 PolyC Nat PolyC;
  Refine PowerPoly1 COMPLEX_Ring;
Save;

(* --------------------------------------------------------------------------------
*)

Goal Commutative PlusPC;
  Refine PlusRg_commut PolyRingC;
Save PlusPC_commut;

Goal {x,y:el PolyC} Eq (PlusPC.ap2 (NegPC.ap x) (NegPC.ap y))
                       (NegPC.ap (PlusPC.ap2 x y));
  Refine PlusNegRg_distrib PolyRingC;
Save PlusNegPC_distrib;

Goal {x,y:el PolyC} Eq (TimesPC.ap2 x (NegPC.ap y)) (NegPC.ap (TimesPC.ap2 x y));
  Refine rTimesNegRg_distrib PolyRingC;
Save rTimesNegPC_distrib;

Goal {x,y:el PolyC} Eq (TimesPC.ap2 (NegPC.ap x) y) (NegPC.ap (TimesPC.ap2 x y));
  Refine lTimesNegRg_distrib PolyRingC;
Save lTimesNegPC_distrib;

Goal {x:el Cplx} Eq (NegPC.ap (ConstPolyC.ap x)) (ConstPolyC.ap (NegC.ap x));
  Refine MapGrP1_const NegC_homoGr;
Save NegPC_const;

Goal Involutive NegPC;
  Refine MapGrP1_invol NegC_homoGr NegC_invol;
Save NegPC_invol;

(* --------------------------------------------------------------------------------
*)

Goal ReP : Fun PolyC PolyR;
  Refine MapGrP1 Re_homoGr;
Save;

Goal ImP : Fun PolyC PolyR;
  Refine MapGrP1 Im_homoGr;
Save;

Goal CpP : Fun PolyR PolyC;
  Refine MapRgP1 Cp_homoRg;
Save;

Goal CpiP : Fun PolyR PolyC;
  Refine MapGrP1 Cpi_homoGr;
Save;

(* --------------------------------------------------------------------------------
*)

Goal {f:el PolyC}{i:el Nat} Eq (CoefR.ap2 (ReP.ap f) i) (Re.ap (CoefC.ap2 f i));
  Refine MapGrP1_distrib|COMPLEX_Ring|REAL_Ring Re_homoGr;
Save ReP_distrib;

Goal {f:el PolyC}{i:el Nat} Eq (CoefR.ap2 (ImP.ap f) i) (Im.ap (CoefC.ap2 f i));
  Refine MapGrP1_distrib|COMPLEX_Ring|REAL_Ring Im_homoGr;
Save ImP_distrib;

Goal {f:el PolyR}{i:el Nat} Eq (CoefC.ap2 (CpP.ap f) i) (cp (CoefR.ap2 f i));
  Refine MapRgP1_distrib|REAL_Ring|COMPLEX_Ring Cp_homoRg;
Save CpP_distrib;

Goal {f:el PolyR}{i:el Nat} Eq (CoefC.ap2 (CpiP.ap f) i) (cpi (CoefR.ap2 f i));
  Refine MapGrP1_distrib|REAL_Ring|COMPLEX_Ring Cpi_homoGr;
Save CpiP_distrib;

Goal {f:el PolyC} Eq (PlusPC.ap2 (CpP.ap (ReP.ap f)) (CpiP.ap (ImP.ap f))) f;
  Intros __;
  Refine Eq_trans (PlusC.ap2 (CoefC.ap2 (CpP.ap (ReP.ap f)) i)
                             (CoefC.ap2 (CpiP.ap (ImP.ap f)) i));
    Refine PlusPoly1_distrib COMPLEX_Ring;
  Refine Eq_trans (PlusC.ap2 (cp (CoefC.ap2 f i).re) (cpi (CoefC.ap2 f i).im));
    Refine exten2;
    Refine Eq_trans (cp (CoefR.ap2 (ReP.ap f) i));
      Refine CpP_distrib; Refine exten Cp; Refine ReP_distrib;
    Refine Eq_trans (cpi (CoefR.ap2 (ImP.ap f) i));
      Refine CpiP_distrib; Refine exten Cpi; Refine ImP_distrib;
  Refine Cplx_lemma1;
Save CplxP_lemma1;

(* --------------------------------------------------------------------------------
*)

Goal ConjP : Fun PolyC PolyC;
  Refine MapRgP1 Conj_homoRg;
Save;

Goal {f:el PolyC}{i:el Nat} Eq (CoefC.ap2 (ConjP.ap f) i) (Conj.ap (CoefC.ap2 f i));
  Refine MapRgP1_distrib Conj_homoRg;
Save ConjP_distrib;

Goal Eq (ConjP.ap ZeroPC) ZeroPC;
  Refine MapRgP1_zero Conj_homoRg;
Save ConjP_zero;

Goal Eq (ConjP.ap OnePC) OnePC;
  Refine MapRgP1_one Conj_homoRg;
Save ConjP_one;

Goal {x,y:el PolyC}
     Eq (ConjP.ap (PlusPC.ap2 x y)) (PlusPC.ap2 (ConjP.ap x) (ConjP.ap y));
  Refine MapRgP1_plus Conj_homoRg;
Save ConjP_plus;

Goal {x:el PolyC} Eq (ConjP.ap (NegPC.ap x)) (NegPC.ap (ConjP.ap x));
  Refine MapRgP1_neg Conj_homoRg;
Save ConjP_neg;

Goal {x,y:el PolyC}
     Eq (ConjP.ap (TimesPC.ap2 x y)) (TimesPC.ap2 (ConjP.ap x) (ConjP.ap y));
  Refine MapRgP1_times Conj_homoRg;
Save ConjP_times;

Goal {x:el PolyC}{n:el Nat}
     Eq (ConjP.ap (PowerPC.ap2 x n)) (PowerPC.ap2 (ConjP.ap x) n);
  Refine MapRgP1_power Conj_homoRg;
Save ConjP_power;

Goal {x:el Cplx} Eq (ConjP.ap (ConstPolyC.ap x)) (ConstPolyC.ap (Conj.ap x));
  Refine MapRgP1_const Conj_homoRg;
Save ConjP_const;

Goal Eq (ConjP.ap IdPolyC) IdPolyC;
  Refine MapRgP1_id Conj_homoRg;
Save ConjP_id;

Goal Involutive ConjP;
  Refine MapRgP1_invol Conj_homoRg Conj_invol;
Save ConjP_invol;

Goal {P|el PolyC} (Eq P (ConjP.ap P)) -> Eq (CpP.ap (ReP.ap P)) P;
  Intros ___;
  Equiv Eq (CoefC.ap2 (CpP.ap (ReP.ap P)) i) (CoefC.ap2 P i);
  Refine Eq_trans (CoefR.ap2 (ReP.ap P) i).cp;
    Refine CpP_distrib;
  Refine Eq_trans (re (CoefC.ap2 P i)).cp;
    Refine exten Cp; Refine ReP_distrib;
  Refine Cp_lemma; Refine ConjIsReal;
  Refine Eq_trans (CoefC.ap2 (ConjP.ap P) i);
    Refine H;
  Refine ConjP_distrib;
Save CpP_lemma;

Goal {P|el PolyC} (Eq P (ConjP.ap P)) -> Eq (ImP.ap P) ZeroPR;
  Intros ___;
  Refine Eq_trans ZeroR;
    Refine +1 (CoefPoly_zero NatIMonoid REAL_Ring i).Eq_sym;
  Equiv Eq (CoefR.ap2 (ImP.ap P) i) ZeroR;
  Refine Eq_trans (CoefC.ap2 P i).im;
    Refine ImP_distrib;
  Refine ConjIsReal;
  Refine Eq_trans (CoefC.ap2 (ConjP.ap P) i);
    Refine H;
  Refine ConjP_distrib;
Save ConjP_IsReal;

Goal {P:el PolyC} (Eq (ImP.ap P) ZeroPR) -> Eq P (ConjP.ap P);
  Intros ___;
  Equiv Eq (CoefC.ap2 P i) (CoefC.ap2 (ConjP.ap P) i);
  Refine Eq_trans (Conj.ap (CoefC.ap2 P i));
    Refine +1 (ConjP_distrib P i).Eq_sym;
  Refine IsRealConj;
  Refine Eq_trans (CoefR.ap2 (ImP.ap P) i);
    Refine (ImP_distrib P i).Eq_sym;
  Refine Eq_trans (CoefR.ap2 ZeroPR i);
    Refine +1 CoefPoly_zero NatIMonoid REAL_Ring;
  Equiv Eq (coefPoly NatIMonoid REAL_Ring (ImP.ap P) i)
           (coefPoly NatIMonoid REAL_Ring ZeroPR i);
  Refine H;
Save IsReal_ConjP;

Goal PlusPC_distrib
   : {f,g:el PolyC} {i:el Nat}
     Eq (CoefC.ap2 (PlusPC.ap2 f g) i)
        (PlusC.ap2 (CoefC.ap2 f i) (CoefC.ap2 g i));
  Refine PlusPoly1_distrib COMPLEX_Ring;
Save;

Goal {f:el PolyC}{x:el Cplx}{i:el Nat}
      Eq (CoefC.ap2 (TimesPC.ap2 (ConstPolyC.ap x) f) i)
         (TimesC.ap2 x (CoefC.ap2 f i));
  Refine lTimesPoly_const NatIMonoid COMPLEX_Ring;
Save lTimesPolyC_const;

Goal {c:el Cplx}{n:el Nat}
     Eq (CoefC.ap2 (PowerPC.ap2 (PlusPC.ap2 IdPolyC (ConstPolyC.ap c)) n) n) OneC;
  Refine FPoly_binon_lemma1 COMPLEX Cplx_discr;
Save PolyC_binon_lemma1;

(* --------------------------------------------------------------------------------
   Define the application.
*)

Goal ApPC : Fun2 PolyC Cplx Cplx;
  Refine ApP1 COMPLEX_Ring;
Save;

Goal apPC : PolyC.el -> op Cplx.el;
  Refine apP1 COMPLEX_Ring;
Save;

Goal {c,x:el Cplx} Eq (apPC (ConstPolyC.ap c) x) c;
  Refine apP1_const COMPLEX_Ring;
Save apPC_const;

Goal {x:el Cplx} Eq (apPC IdPolyC x) x;
  Refine apP1_id COMPLEX_Ring;
Save apPC_id;

Goal {f,g:el PolyC} {x:el Cplx}
     Eq (apPC (PlusPC.ap2 f g) x) (PlusC.ap2 (apPC f x) (apPC g x));
  Refine apP1_plus COMPLEX_Ring;
Save apPC_plus;

Goal {f,g:el PolyC}{x:el Cplx}
     Eq (apPC (TimesPC.ap2 f g) x) (TimesC.ap2 (apPC f x) (apPC g x));
  Refine apP1_times COMPLEX_Ring TimesC_commut;
Save apPC_times;

Goal {f:el PolyC}{n:el Nat}{x:el Cplx}
     Eq (apPC (PowerPC.ap2 f n) x) (PowerC.ap2 (apPC f x) n);
  Refine apP1_power COMPLEX_Ring TimesC_commut;
Save apPC_power;

(* --------------------------------------------------------------------------------
*)

Goal {P:el PolyR} {x:el Real}
     Eq (Cp.ap (apPR P x))
        (apPC (CpP.ap P) (Cp.ap x));
  Refine apP1_lemma1 Cp_homoRg;
Save apP_Cp_distrib;

Goal {P:el PolyC} {x:el Cplx}
     Eq (Conj.ap (apPC P x))
        (apPC (ConjP.ap P) (Conj.ap x));
  Refine apP1_lemma1 Conj_homoRg;
Save apP_Conj_distrib;

(* --------------------------------------------------------------------------------
   Define the degree.
*)

Goal DegreeC : Fun PolyC Nat;
  Refine DegreeFP1 COMPLEX Cplx_discr;
Save;

Goal degreeC' : PolyC.el -> PolyC.el -> Nat.el;
  Refine degreeP1' COMPLEX_Ring Cplx_discr;
Save;

Goal {f,g:el PolyC} LessEqN.ap2 (DegreeC.ap (PlusPC.ap2 f g))
                                (MaxN.ap2 (DegreeC.ap f) (DegreeC.ap g));
  Refine DegreeFP1_plus COMPLEX Cplx_discr;
Save DegreeC_plus;

Goal {P:el PolyC}{x:el Cplx}
     Eq (DegreeC.ap (PlusPC.ap2 P (ConstPolyC.ap x))) (DegreeC.ap P);
  Refine DegreeFP1_plus_const COMPLEX Cplx_discr;
Save DegreeC_plus_const;

Goal {c|el Cplx} ~(Eq c ZeroC) -> {f:el PolyC}
     Eq (DegreeC.ap (TimesPC.ap2 (ConstPolyC.ap c) f)) (DegreeC.ap f);
  Refine DegreeFP1_const_times COMPLEX Cplx_discr;
Save DegreeC_const_times;

Goal {P:el PolyC} {n:el Nat}
     Eq (DegreeC.ap (PowerPC.ap2 P n)) (TimesN.ap2 n (DegreeC.ap P));
  Refine DegreeP1_power COMPLEX Cplx_discr;
Save DegreeC_power;

Freeze PlusC TimesC RecipC NegC;

Goal {P:el PolyC} (Eq P (ConjP.ap P)) -> Eq (DegreeR.ap (ReP.ap P)) (DegreeC.ap P);
  intros; [reP = ReP.ap P];
  Refine list_ind [f:el PolyC] Eq (degreeR' reP (ReP.ap f)) (degreeC' P f);

  Refine Eq_trans ZeroN ??.Eq_sym;
    Refine DegreeP'_zero NatIMonoid REAL_Ring Real_discr reP;
  Refine DegreeP'_zero NatIMonoid COMPLEX_Ring Cplx_discr P;

  intros t f ih; [t1 = IndexMonC.ap t];
  [DegPf = degreeC' P f] [DegRef = degreeR' reP (ReP.ap f)];
  Refine Eq_trans (if Real_discr (CoefR.ap2 reP t1) ZeroR DegRef (MaxN.ap2 t1 DegRef));
    Refine DegreeP'_plusMP NatIMonoid REAL_Ring Real_discr reP ? (ReP.ap f);
  Refine Eq_trans (if Cplx_discr (CoefC.ap2 P t1) ZeroC DegPf (MaxN.ap2 t1 DegPf));
    Refine +1 Eq_sym;
    Refine +1 DegreeP'_plusMP NatIMonoid COMPLEX_Ring Cplx_discr P ? f;
  Refine if_exten ? ? ih (exten2 ? ?.Eq_refl ih);
  intros;
    Refine Eq_trans (CoefC.ap2 (CpP.ap (ReP.ap P)) t1);
      Refine exten2 ? ?.Eq_sym ?.Eq_refl; Refine CpP_lemma H;
    Refine Eq_trans (Cp.ap (CoefR.ap2 (ReP.ap P) t1));
      Refine CpP_distrib;
    Refine eq_cplx_intro; Refine H1; Refine Eq_refl;
  intros;
    Refine Eq_trans (Re.ap (CoefC.ap2 P t1));
      Refine ReP_distrib;
    Refine exten ? H1;
Save DegreeC_lemma1;

Unfreeze PlusC TimesC RecipC NegC;

