
Module Group Import Monoid;

[     sigGr : Signature
          = Signature_intro (ThreeSET_iter ZeroN  (* a constant *)
                                           OneN   (* a unary function *)
                                           TwoN   (* a binary function *)
                            ) 
                            EmptySET_nat
];

Goal axiomsGr : Axioms sigGr;
  Refine Axioms_intro;
  Intros A IC IP;
  One   == (IC star31).apn : el A;
  Inv   == IC star32       : Fun A A;
  Times == IC star33       : Fun2 A A A;
  Refine and3 (Associative Times) (Inverse Times One Inv) (Identity Times One);
Save;

[     Group
          = Model axiomsGr
];

(* --------------------------------------------------------------------------------
   Define a term to contruct a new group.
*)

[A|Set] [Times|Fun2 A A A] [Inv|Fun A A] [One|el A];
[Times_assoc : Associative Times]
[rInv_invers : rInverse Times One Inv]
[rOne_ident : rIdentity Times One];

Goal InvGr_invers_intro : lInverse Times One Inv;
  Intros x; [mx = Inv.ap x] [mmx = Inv.ap mx];
  Refine Eq_trans (Times.ap2 (Times.ap2 mx x) One);
    Refine Eq_sym; Refine rOne_ident;
  Refine Eq_trans (Times.ap2 (Times.ap2 mx x) (Times.ap2 mx mmx));
    Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine rInv_invers;
  Refine Eq_trans (Times.ap2 mx (Times.ap2 x (Times.ap2 mx mmx)));
    Refine Eq_sym; Refine Times_assoc;
  Refine Eq_trans (Times.ap2 mx (Times.ap2 One mmx));
    Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (Times.ap2 (Times.ap2 x mx) mmx);
    Refine Times_assoc; Refine exten2 ? ? ?.Eq_refl; Refine rInv_invers;
  Refine Eq_trans (Times.ap2 (Times.ap2 mx One) mmx);
    Refine Times_assoc;
  Refine Eq_trans (Times.ap2 mx mmx);
    Refine exten2 ? ? ?.Eq_refl; Refine rOne_ident; Refine rInv_invers;
Save;

Goal OneGr_ident_intro : lIdentity Times One;
  Intros x; [mx = Inv.ap x];
  Refine Eq_trans (Times.ap2 (Times.ap2 x mx) x);
    Refine exten2 ? ? ?.Eq_refl; Refine Eq_sym; Refine rInv_invers;
  Refine Eq_trans (Times.ap2 x (Times.ap2 mx x));
    Refine Eq_sym; Refine Times_assoc;
  Refine Eq_trans (Times.ap2 x One);
    Refine exten2 ? ?.Eq_refl; Refine InvGr_invers_intro; Refine rOne_ident;
Save;

Goal Group_intro : Group;
  intros;
  Refine Model_intro;
  Refine A;
  Refine ThreeSET_elim [c:FuncSymb sigGr] nFunc A (FuncArity c);
  Refine constant One;
  Refine Inv;
  Refine Times;
  intros; Refine EmptySET_iter p;
  Refine pair3 Times_assoc
               (pair InvGr_invers_intro rInv_invers)
               (pair OneGr_ident_intro rOne_ident);
Save;

Discharge A;

(* --------------------------------------------------------------------------------
   Let G be a group. Define functions to extract all components of G.
*)

[G : Group];

  [OneGr         : obj G                        = intCons G star31]
  [InvGr         : UFunMdl G                    = intFunc G star32]
  [TimesGr       : BFunMdl G                    = intFunc G star33];

  [TimesGr_assoc : Associative TimesGr          = and3_out1 G.axioms]
  [InvGr_invers  : Inverse TimesGr OneGr InvGr  = and3_out2 G.axioms]
  [OneGr_ident   : Identity TimesGr OneGr       = and3_out3 G.axioms];

Freeze OneGr InvGr TimesGr;

  [lInvGr_invers : lInverse TimesGr OneGr InvGr = fst InvGr_invers]
  [lOneGr_ident  : lIdentity TimesGr OneGr      = fst OneGr_ident]
  [rInvGr_invers : rInverse TimesGr OneGr InvGr = snd InvGr_invers]
  [rOneGr_ident  : rIdentity TimesGr OneGr      = snd OneGr_ident];

  [MonoidGr      : Monoid                     = Monoid_intro TimesGr_assoc OneGr_ident];
  [SquareGr      : Fun G.car G.car            = MonoidGr.SquareMN];
  [PowerGr       : Fun2 G.car Nat G.car       = MonoidGr.PowerMN];

  [rTimesGr_commut : (Commutative TimesGr) ->
                     {x,y,z:obj G} Eq (TimesGr.ap2 (TimesGr.ap2 x y) z)
                                      (TimesGr.ap2 (TimesGr.ap2 x z) y)
           = MonoidGr.rTimesMN_commut
  ];

  [lTimesGr_commut : (Commutative TimesGr) ->
                     {x,y,z:obj G} Eq (TimesGr.ap2 x (TimesGr.ap2 y z))
                                      (TimesGr.ap2 y (TimesGr.ap2 x z))
           = MonoidGr.lTimesMN_commut
  ];

(* --------------------------------------------------------------------------------
   Prove a list of lemma's valid for groups.
*)

  Goal DivGr : BFunMdl G;
    Refine Fun2_intro;
    Refine [x,y:obj G] TimesGr.ap2 x (InvGr.ap y);
    Intros; Refine exten2 ? H; Refine exten ? H1;
  Save;

  Goal InvGr_invol : Involutive InvGr;
    Intros x;
    Refine Eq_trans (TimesGr.ap2 OneGr (InvGr.ap (InvGr.ap x)));
      Refine Eq_sym; Refine lOneGr_ident;
    Refine Eq_trans (TimesGr.ap2 (TimesGr.ap2 x (InvGr.ap x)) (InvGr.ap (InvGr.ap x)));
      Refine exten2; Refine Eq_sym; Refine rInvGr_invers; Refine Eq_refl;
    Refine Eq_trans (TimesGr.ap2 x (TimesGr.ap2 (InvGr.ap x) (InvGr.ap (InvGr.ap x))));
      Refine Eq_sym; Refine TimesGr_assoc;
    Refine Eq_trans (TimesGr.ap2 x OneGr);
      Refine exten2; Refine Eq_refl; Refine rInvGr_invers;
    Refine rOneGr_ident;
  Save;

  Goal DivGr_lemma1 : {x,y|obj G} (Eq (DivGr.ap2 x y) OneGr) -> Eq x y;
    intros;
    Refine Eq_trans (TimesGr.ap2 x OneGr);
      Refine Eq_sym; Refine rOneGr_ident;
    Refine Eq_trans (TimesGr.ap2 x (TimesGr.ap2 (InvGr.ap y) y));
      Refine exten2; Refine Eq_refl; Refine Eq_sym; Refine lInvGr_invers;
    Refine Eq_trans (TimesGr.ap2 (TimesGr.ap2 x (InvGr.ap y)) y);
      Refine TimesGr_assoc;
    Refine Eq_trans (TimesGr.ap2 OneGr y);
      Refine exten2; Refine H; Refine Eq_refl;
    Refine lOneGr_ident;
  Save;

  Goal rTimesGr_cancel : rCancelation TimesGr;
    Intros a x y H;
    Refine Eq_trans (TimesGr.ap2 x OneGr);
      Refine Eq_sym; Refine rOneGr_ident;
    Refine Eq_trans (TimesGr.ap2 x (DivGr.ap2 a a));
      Refine exten2; Refine Eq_refl; Refine Eq_sym; Refine rInvGr_invers;
    Refine Eq_trans (DivGr.ap2 (TimesGr.ap2 x a) a);
      Refine TimesGr_assoc;
    Refine Eq_trans (DivGr.ap2 (TimesGr.ap2 y a) a);
      Refine exten2; Refine H; Refine Eq_refl;
    Refine Eq_trans (TimesGr.ap2 y (DivGr.ap2 a a));
      Refine Eq_sym; Refine TimesGr_assoc;
    Refine Eq_trans (TimesGr.ap2 y OneGr);
      Refine exten2; Refine Eq_refl; Refine rInvGr_invers;
    Refine rOneGr_ident;
  Save;

  Goal lTimesGr_cancel : lCancelation TimesGr;
    Intros a x y H;
    Refine Eq_trans (TimesGr.ap2 OneGr x);
      Refine Eq_sym; Refine lOneGr_ident;
    Refine Eq_trans (TimesGr.ap2 (TimesGr.ap2 (InvGr.ap a) a) x);
      Refine exten2; Refine Eq_sym; Refine lInvGr_invers; Refine Eq_refl;
    Refine Eq_trans (TimesGr.ap2 (InvGr.ap a) (TimesGr.ap2 a x));
      Refine Eq_sym; Refine TimesGr_assoc;
    Refine Eq_trans (TimesGr.ap2 (InvGr.ap a) (TimesGr.ap2 a y));
      Refine exten2; Refine Eq_refl; Refine H;
    Refine Eq_trans (TimesGr.ap2 (TimesGr.ap2 (InvGr.ap a) a) y);
      Refine TimesGr_assoc;
    Refine Eq_trans (TimesGr.ap2 OneGr y);
      Refine exten2; Refine lInvGr_invers; Refine Eq_refl;
    Refine lOneGr_ident;
  Save;

  Goal TimesGr_cancel : Cancelation TimesGr;
    Refine pair lTimesGr_cancel rTimesGr_cancel;
  Save;

  Goal InvOneGr : Eq (InvGr.ap OneGr) OneGr;
    Refine lTimesGr_cancel OneGr;
    Refine Eq_trans OneGr;
    Refine rInvGr_invers;
    Refine Eq_sym; Refine rOneGr_ident;
  Save;

  Goal rInvOneGr_ident : rIdentity TimesGr (InvGr.ap OneGr);
    Intros x;
    Refine Eq_trans (TimesGr.ap2 x OneGr);
    Refine exten2; Refine Eq_refl; Refine InvOneGr;
    Refine rOneGr_ident;
  Save;

  Goal lInvOneGr_ident : lIdentity TimesGr (InvGr.ap OneGr);
    Intros x;
    Refine Eq_trans (TimesGr.ap2 OneGr x);
    Refine exten2; Refine InvOneGr; Refine Eq_refl;
    Refine lOneGr_ident;
  Save;

  Goal InvOneGr_ident : Identity TimesGr (InvGr.ap OneGr);
    Refine pair lInvOneGr_ident rInvOneGr_ident;
  Save;

  Goal TimesInvGr_distrib
     : {x,y:obj G} Eq (TimesGr.ap2 (InvGr.ap x) (InvGr.ap y))
                         (InvGr.ap (TimesGr.ap2 y x));
    Intros;
    Refine Eq_trans (TimesGr.ap2 (DivGr.ap2 (InvGr.ap x) y) OneGr);
      Refine Eq_sym; Refine rOneGr_ident;
    Refine Eq_trans (TimesGr.ap2 (DivGr.ap2 (InvGr.ap x ) y)
                    (DivGr.ap2 (TimesGr.ap2 y x) (TimesGr.ap2 y x)));
      Refine exten2; Refine Eq_refl; Refine Eq_sym; Refine rInvGr_invers;
    Refine Eq_trans (DivGr.ap2 (TimesGr.ap2 (DivGr.ap2 (InvGr.ap x ) y)
                                             (TimesGr.ap2 y x)) (TimesGr.ap2 y x));
      Refine TimesGr_assoc;
    Refine Eq_trans (DivGr.ap2 OneGr (TimesGr.ap2 y x));
      Refine +1 lOneGr_ident;
    Refine exten2; Refine +1 Eq_refl;
    Refine Eq_trans (TimesGr.ap2 (TimesGr.ap2 (DivGr.ap2 (InvGr.ap x) y) y) x);
      Refine TimesGr_assoc;
    Refine Eq_trans (TimesGr.ap2 (TimesGr.ap2 (InvGr.ap x)
                                              (TimesGr.ap2 (InvGr.ap y) y)) x);
      Refine exten2; Refine Eq_sym; Refine TimesGr_assoc; Refine Eq_refl;
    Refine Eq_trans (TimesGr.ap2 (TimesGr.ap2 (InvGr.ap x) OneGr) x);
      Refine exten2; Refine exten2; Refine Eq_refl; Refine lInvGr_invers;
                     Refine Eq_refl;
    Refine Eq_trans (TimesGr.ap2 (InvGr.ap x) x);
      Refine exten2; Refine rOneGr_ident; Refine Eq_refl;
    Refine lInvGr_invers;
  Save;

  Goal InvGr_inj : Injection InvGr;
    Intros ___;
    Refine Eq_trans (InvGr.ap (InvGr.ap a));
      Refine Eq_sym; Refine InvGr_invol;
    Refine Eq_trans (InvGr.ap (InvGr.ap a'));
      Refine exten ? H;
    Refine InvGr_invol;
  Save;

  Goal InvGr_one : {x|obj G} (Eq (InvGr.ap x) OneGr) -> Eq x OneGr;
    intros;
    Refine InvGr_inj;
    Refine Eq_trans OneGr H InvOneGr.Eq_sym;
  Save;

  Goal InvGr_not_one : {x|obj G} ~(Eq x OneGr) -> ~(Eq (InvGr.ap x) OneGr);
    intros _; Refine Contrapos (InvGr_one|x);
  Save;

  Goal InvGr_lemma1 : {x|obj G} (Eq x OneGr) -> Eq x (InvGr.ap x);
    intros;
    Refine Eq_trans OneGr;
      Refine H;
    Refine Eq_trans (InvGr.ap OneGr);
      Refine Eq_sym; Refine InvOneGr;
    Refine exten ? H.Eq_sym;
  Save;

Discharge G;

Unfreeze OneGr InvGr TimesGr;
