
Module FPoly_degree Import Field Poly_degree;

[IMN : indexMonoid]

  $[B_discr : Discrete IMN.car            = indexMonoid_discr IMN];

  $[PlusB   : BFunMdl IMN                 = PlusIMN IMN];
  $[ZeroB   : obj IMN                     = ZeroIMN IMN];
  $[LessEqB : BRelMdl IMN                 = LessEqIMN IMN];
  $[LessB   : BRelMdl IMN                 = LessIMN IMN];
  $[MaxB    : BFunMdl IMN                 = Max IMN.IMN_total_order];

[F : Field] [F_discr : Discrete F.car] $[R : Ring = F.RingFd];

  [MonomialF : Set = Monomial IMN R];

  Goal CoefMonF : Fun MonomialF F.car;
    Refine CoefMon IMN R;
  Save;

  Goal IndexMonF : Fun MonomialF IMN.car;
    Refine IndexMon IMN R;
  Save;

  Goal MonomialF_intro : Fun2 F.car IMN.car MonomialF;
    Refine Monomial_intro IMN R;
  Save;

[FPolyRing : Ring = PolyRing IMN R];

  Goal FPoly : Set;
    Refine Polyn IMN R;
  Save;

  Goal CoefFPoly : Fun2 FPolyRing.car IMN.car F.car;
    Refine CoefPoly IMN R;
  Save;

  Goal ZeroFPoly : obj FPolyRing;
    Refine ZeroPoly IMN R;
  Save;

  Goal OneFPoly : obj FPolyRing;
    Refine OnePoly IMN R;
  Save;

  Goal Monomial2FPoly : Fun MonomialF FPoly;
    Refine Monomial2Poly IMN R;
  Save;

  Goal ConstFPoly : Fun F.car FPoly;
    Refine ConstPoly IMN R;
  Save;

  Goal NegFPoly : UFunMdl FPolyRing;
    Refine NegPoly IMN R;
  Save;

  Goal PlusFPoly : BFunMdl FPolyRing;
    Refine PlusPoly IMN R;
  Save;

  Goal TimesFPoly : BFunMdl FPolyRing;
    Refine TimesPoly IMN R;
  Save;

  Goal PowerFPoly : Fun2 FPoly Nat FPoly;
    Refine PowerPoly IMN R;
  Save;

  Goal DegreeFP : Fun FPoly IMN.car;
    Refine DegreeP IMN R F_discr;
  Save;

  Goal LCoefFP : Fun FPoly F.car;
    Refine LCoefP IMN R F_discr;
  Save;

(* --------------------------------------------------------------------------------
   Prove (f!=0)  ->  (g!=0)  ->  (degree(f g) = (degree f) + (degree g))
*)

Goal DegreeFP_timesMP_phi : MonomialF.el -> Pred FPoly;
  intros t;
  Refine Pred_intro;
  intros g;
  Refine ~(Eq g ZeroFPoly) -> Eq (DegreeFP.ap ((TimesMP IMN R).ap2 t g))
                                 (PlusB.ap2 (IndexMonF.ap t) (DegreeFP.ap g));
  Intros f g ___;
  Refine Eq_trans (DegreeFP.ap ((TimesMP IMN R).ap2 t f));
    Refine exten; Refine exten2 ??.Eq_refl H.Eq_sym;
  Refine Eq_trans (PlusB.ap2 (IndexMonF.ap t) (DegreeFP.ap f));
    Refine +1 exten2 ??.Eq_refl; Refine +1 exten ? H;
  Refine H1; Intros _; Refine H2; Refine Eq_trans ? H.Eq_sym H3;
Save;

Goal {t|el MonomialF}{g|el FPoly}
      ~(Eq (CoefMonF.ap t) F.ZeroFd) ->
     ~(Eq g ZeroFPoly) ->
     Eq (DegreeFP.ap ((TimesMP IMN R).ap2 t g))
        (PlusB.ap2 (IndexMonF.ap t) (DegreeFP.ap g));
  intros t g' _;
  Refine Poly_degree_ind IMN R F_discr t.DegreeFP_timesMP_phi;
  Intros; Refine H1; Refine Eq_refl;
  Intros u __;
    Refine Eq_trans (PlusB.ap2 (IndexMonF.ap t) (IndexMonF.ap u));
      Refine +1 exten2 ? ?.Eq_refl ?.Eq_sym;
      Refine +1 DegreeP_monom IMN R F_discr H1;
    Refine DegreeP_monom IMN R F_discr;
    Refine TimesFd_not_zero F H H1;
  Intros g u ih ___;
    Refine Eq_trans (PlusB.ap2 (IndexMonF.ap t) (IndexMonF.ap u));
      Refine +1 exten2 ? ?.Eq_refl ?.Eq_sym;
      Refine +1 DegreeP_eq_cons IMN R F_discr H1 H2;
    Refine DegreeP_eq_cons IMN R F_discr;
      Refine TimesFd_not_zero F H H1;
    Equiv IMN.LessIMN.ap2 (DegreeFP.ap ((TimesMP IMN R).ap2 t g))
                          (IndexMonF.ap ((TimesMon IMN R).ap2 t u));
    orE Poly_discr IMN R F_discr g ZeroFPoly;
    intros;
      Refine LessLessEq_trans IMN.IMN_total_order (IndexMonF.ap u);
        Refine +1 IMN.lLessEqIMN_lemma1;
      Refine extenRel ? ? ?.Eq_refl H2;
      Refine TimesMP_degree_zero IMN R F_discr H4;
    intros;
      Refine extenRel ? ?.Eq_sym ?.Eq_refl;
        Refine +1 ih H4;
      Refine lLessIMN_plus IMN ? H2;
Save DegreeFP_timesMP;

Goal DegreeFP_times_phi : FPoly.el -> Pred FPoly;
  intros g;
  Refine Pred_intro;
  intros f;
  Refine ~(Eq f ZeroFPoly) ->
    Eq (DegreeFP.ap (TimesFPoly.ap2 f g)) (PlusB.ap2 (DegreeFP.ap f) (DegreeFP.ap g));
  Intros _____;
  Refine Eq_trans (ap DegreeFP (ap2 TimesFPoly x g));
    Refine exten; Refine exten2 ? H.Eq_sym ?.Eq_refl;
  Refine Eq_trans (ap2 PlusB (ap DegreeFP x) (ap DegreeFP g));
    Refine +1 exten2 ???.Eq_refl; Refine +1 exten ? H;
  Refine H1;
  Intros _; Refine H2; Refine Eq_trans ? H.Eq_sym H3;
Save;

Goal {f,g|el FPoly}
     ~(Eq f ZeroFPoly) -> ~(Eq g ZeroFPoly) ->
     Eq (DegreeFP.ap (TimesFPoly.ap2 f g)) (PlusB.ap2 (DegreeFP.ap f) (DegreeFP.ap g));
  intros f' ___;
  Refine Poly_degree_ind IMN R F_discr g.DegreeFP_times_phi;
  Refine +3 H;
  Intros _; Refine H2; Refine Eq_refl;
  Intros t __;
    [tg = ((TimesMP IMN R).ap2 t g)];
    Refine Eq_trans (DegreeFP.ap tg);
      Refine exten;
      Equiv Eq (PlusFPoly.ap2 tg ZeroFPoly) tg;
      Refine rZeroPoly_ident IMN R;
    Refine Eq_trans (PlusB.ap2 (IndexMonF.ap t) (DegreeFP.ap g));
      Refine DegreeFP_timesMP H2 H1;
    Refine exten2 ??.Eq_sym ?.Eq_refl;
    Refine DegreeP_monom IMN R F_discr H2;
  Intros f t ____;
    [tg = ((TimesMP IMN R).ap2 t g)];
    Refine Eq_trans (PlusB.ap2 (IndexMonF.ap t) (DegreeFP.ap g));
      Refine +1 exten2 ??.Eq_sym ?.Eq_refl;
      Refine +1 DegreeP_eq_cons IMN R F_discr H3 H4;
    Refine Eq_trans (DegreeFP.ap tg);
      Refine +1 DegreeFP_timesMP H3 H1;
    Refine DegreePlusP_lemma' IMN R F_discr;
    Equiv LessB.ap2 (DegreeFP.ap (TimesFPoly.ap2 f g)) (DegreeFP.ap tg);
    Refine extenRel ? ?.Eq_refl ?.Eq_sym; Refine +1 DegreeFP_timesMP H3 H1;
    orE Poly_discr IMN R F_discr f ZeroFPoly;
    intros;
      Refine LessLessEq_trans IMN.IMN_total_order (IndexMonF.ap t);
        Refine +1 IMN.rLessEqIMN_lemma1;
      Refine extenRel ???.Eq_refl H4;
      Refine exten;
      Refine Eq_trans ? H6 ?.Eq_sym;
      Refine Eq_trans (TimesFPoly.ap2 ZeroFPoly g); Refine exten2 ? H6 ?.Eq_refl;
      Refine Eq_refl;
    intros;
      Refine extenRel ??.Eq_sym ?.Eq_refl; Refine +1 H2 H6;
      Refine rLessIMN_plus IMN;
      Refine H4;
Save DegreeFP_times;

(* --------------------------------------------------------------------------------
   Prove (c != 0)  ->  (degree (c f)) = (degree f)
*)

Goal {c|obj F} ~(Eq c F.ZeroFd) -> {f:el FPoly}
     Eq (DegreeFP.ap (TimesFPoly.ap2 (ConstFPoly.ap c) f)) (DegreeFP.ap f);
  intros;
  orE Poly_discr IMN R F_discr f ZeroFPoly;
  intros;
    Refine exten;
    Refine Eq_trans (TimesFPoly.ap2 (ConstFPoly.ap c) ZeroFPoly);
      Refine exten2 ??.Eq_refl H1;
    Refine Eq_trans ZeroFPoly;
      Refine +1 H1.Eq_sym;
    Refine rTimesZeroRg FPolyRing;
  intros;
  Refine Eq_trans (PlusB.ap2 ZeroB (DegreeFP.ap f));
    Refine +1 lZeroIMN_ident;
  Refine Eq_trans (PlusB.ap2 (DegreeFP.ap (ConstFPoly.ap c)) (DegreeFP.ap f));
    Refine +1 exten2 ???.Eq_refl; Refine +1 DegreeP_const IMN R F_discr;
  Refine DegreeFP_times ? H1;
  Intros _; Refine H; Refine ConstPoly_zero IMN R H2;
Save DegreeFP_const_times;

(* --------------------------------------------------------------------------------
   Prove (f != 0)  ->  (g != 0)  ->  (f g) != 0
*)

[f,g | el FPoly];
[f_nnil : ~(Eq f ZeroFPoly)]
[g_nnil : ~(Eq g ZeroFPoly)]
[fg_nil : Eq (TimesFPoly.ap2 f g) ZeroFPoly];

Goal Eq (PlusB.ap2 (DegreeFP.ap f) (DegreeFP.ap g)) ZeroB;
  Refine Eq_trans (DegreeFP.ap (TimesFPoly.ap2 f g)) ?.Eq_sym;
    Refine DegreeFP_times f_nnil g_nnil;
  Refine Eq_trans (DegreeFP.ap ZeroFPoly);
    Refine exten ? fg_nil;
  Refine DegreeP_zero IMN R;
$Save TimesFP_not_zero_lemma1;

Goal Eq (DegreeFP.ap f) ZeroB;
  andE ZeroIMN_lemma1 IMN TimesFP_not_zero_lemma1; Refine H;
$Save TimesFP_not_zero_df0;

Goal Eq (DegreeFP.ap g) ZeroB;
  andE ZeroIMN_lemma1 IMN TimesFP_not_zero_lemma1; Refine H1;
$Save TimesFP_not_zero_dg0;

Goal absurd;
  [lcf = LCoefFP.ap f] [lcg = LCoefFP.ap g];
  Refine TimesFd_not_zero F;
  Refine lcf; Refine lcg;
  Intros _; Refine f_nnil; Refine degreeP_lemma3 IMN R F_discr; Refine H;
  Intros _; Refine g_nnil; Refine degreeP_lemma3 IMN R F_discr; Refine H;
  Refine Eq_trans (CoefFPoly.ap2 (ConstFPoly.ap (F.TimesFd.ap2 lcf lcg)) ZeroB);
    Refine Eq_sym; Refine CoefPoly_const IMN R;
  Refine Eq_trans (CoefFPoly.ap2 ZeroFPoly ZeroB);
    Refine +1 CoefPoly_zero IMN R;
  Refine exten2 ???.Eq_refl;
  Refine Eq_trans ? ? fg_nil;
  Refine Eq_trans (TimesFPoly.ap2 (ConstFPoly.ap lcf) (ConstFPoly.ap lcg));
    Refine ConstPoly_times IMN R;
  Refine exten2 ? ?.Eq_sym ?.Eq_sym;
  Refine LCoefP_const IMN R F_discr f_nnil TimesFP_not_zero_df0;
  Refine LCoefP_const IMN R F_discr g_nnil TimesFP_not_zero_dg0;
Save TimesFPoly_not_zero;

Discharge f;

(* --------------------------------------------------------------------------------
   Prove (f != 0)  ->  f^n != 0
*)

Goal {P|el FPoly} ~(Eq P ZeroFPoly) ->
     {n|el Nat} ~(Eq (PowerFPoly.ap2 P n) ZeroFPoly);
  intros __;
  Refine nat_ind [n:el Nat] ~(Eq (PowerFPoly.ap2 P n) ZeroFPoly);

  Intros _; Refine OneFd_not_zero F;
  Refine Eq_trans (CoefFPoly.ap2 OneFPoly ZeroB);
    Refine Eq_sym; Refine CoefPoly_one IMN R;
  Refine Eq_trans (CoefFPoly.ap2 (PowerFPoly.ap2 P ZeroN) ZeroB);
    Refine exten2 ? ?.Eq_sym ?.Eq_refl; Refine PowerRg_zero FPolyRing;
  Refine CoefPoly_zerop IMN R; Refine H1;

  Intros n ih _; Refine TimesFPoly_not_zero ih H;
  Refine Eq_trans (PowerFPoly.ap2 P (Succ.ap n));
    Refine Eq_sym; Refine PowerRg_succ FPolyRing;
  Refine H1;
Save PowerFPoly_not_zero;

Discharge IMN;
