
Module Bijection Import Pred Choice;

(* 
   This module consist of a few lemma's about surjection/injection using
   a choice principle.
*)

[AC : AxiomOfChoice]
[AUC : AxiomOfUniqueChoice];

[A,B,C | Set];

[f : Fun A B];

Goal Rel B A;
  Refine Rel_intro;
  Refine [b:B.el][a:A.el] Eq (f.ap a) b;
  Intros _______;
  Refine Eq_trans (f.ap y);
    Refine exten; Refine Eq_sym H1;
  Refine Eq_trans x H2 H;
$Save Graph;

(* The next one needs the axiom of choice. *)

Goal f.Surjection -> f.SplitSurjection;
  Intros surj;
  Refine AC Graph;
  Refine surj;
Save Sur2SplitSur;

(* The next one needs the axiom of unique choice. *)

Goal f.Bijection -> f.SplitSurjection;
  intros bij;
  Refine AUC Graph;
  Intros b; Refine pair; Refine snd bij;
  Intros a a' __; Refine fst bij;
    Refine Eq_trans b; Refine +1 Eq_sym; Immed;
Save SplitSurjection_lemma;

Goal f.SplitSurjection -> f.Surjection;
  intros ssur;
  exE ssur; Intros g _ b;
  exI ?; Refine g.ap b;
  Immed;
Save SplitSur2Sur;

Discharge f;

(* The next one needs the axiom of unique choice. *)

Goal iff (Iso A B) (Ex [f:Fun A B] Bijection f);
  intros;
  Refine pair;

  intros; exE H; intros f g _; andE H1; exI ?; Refine f; andI;
  Intros;
    Refine Eq_trans (g.ap (f.ap a)); Refine (H2 a).Eq_sym;
    Refine Eq_trans (g.ap (f.ap a')); Refine +1 H2;
    Refine exten; Immed;
  Refine SplitSur2Sur; exI ?; Refine g; Immed;

  intros; exE H; intros f _;
  exE (SplitSurjection_lemma ? H1); intros g _;
  Refine Ex2Intro; Refine f; Refine g;
  Refine pair;
  Intros; Refine H1.fst; Refine H2;
  Refine H2;
Save Iso_lemma;

Discharge AC;
