
Module Order Import Pred case;

[A | Set];

[     PartiallyOrdered [R : Rel A A]
          = and3 R.Reflexive R.AntiSymmetric R.Transitive
]
[     TotallyOrdered [R : Rel A A]
          = and R.PartiallyOrdered R.Total
];

Goal LessEq_tot_refl : {R|Rel A A} R.Total -> R.Reflexive;
  Intros ___;
  Refine H; Refine +2 Id; Refine Id;
Save;

Goal TotallyOrdered_intro : {R|Rel A A} R.AntiSymmetric -> R.Transitive -> R.Total ->
                                        R.TotallyOrdered;
  intros R R_antisym R_trans R_total;
  Refine pair (pair3 (LessEq_tot_refl R_total) R_antisym R_trans) R_total;
Save;

[LessEq | Rel A A] [TO : TotallyOrdered LessEq];

  [LessEq_refl    : Reflexive     LessEq = and3_out1 TO.fst]
  [LessEq_antisym : AntiSymmetric LessEq = and3_out2 TO.fst]
  [LessEq_trans   : Transitive    LessEq = and3_out3 TO.fst];
  [LessEq_total   : Total         LessEq = snd TO];

  Goal {x,y,z|el A} (LessEq.ap2 x y) -> (LessEq.ap2 y z) -> (LessEq.ap2 z x) -> Eq x z;
    intros;
    Refine (LessEq_antisym H2 ?).Eq_sym;
    Refine LessEq_trans ? H H1;
  Save LessEq_antisym2;

  [     less : A.el->A.el->Prop
            = [x,y:el A] ~(Eq x y) /\ (LessEq.ap2 x y) // TO
  ];

  Goal extensionalRel less;
    Intros _______; Refine pair;
    Intros _; Refine H2.fst;
      Refine Eq_trans x' H; Refine Eq_trans y' H3; Refine Eq_sym H1;
    Refine extenRel ? H H1 H2.snd;
  Save less_exten;

  [     Less : Rel A A
            = Rel_intro less less_exten
  ];

  Goal Transitive Less;
    Intros _____;
    Refine pair;
    Intros _; Refine H.fst; Refine LessEq_antisym H.snd;
      Refine extenRel ? ?.Eq_refl H2.Eq_sym H1.snd;
    Refine LessEq_trans ? H.snd H1.snd;
  Save Less_trans;

  Goal Irreflexive Less;
    Intros __;
    Refine H.fst; Refine Eq_refl;
  Save Less_irrefl;

  Goal {x,y|el A} (Less.ap2 x y) -> ~(LessEq.ap2 y x);
    Intros ____;
    Refine H.fst; Refine LessEq_antisym H.snd H1;
  Save Less_elim;

  Goal {x,y|el A} (LessEq.ap2 x y) -> ~(Less.ap2 y x);
    Intros ____;
    Refine Less_elim H1 H;
  Save LessEq_elim;

  Goal {x,y|el A} (Less.ap2 x y) -> (Less.ap2 y x) -> absurd;
    intros;
    Refine Less_elim H H1.snd;
  Save Less_antisym;

  Goal {x|el A}{y:el A}{z|el A}
       (LessEq.ap2 x y) -> (Less.ap2 y z) -> (Less.ap2 x z);
    intros; Refine H1;
    intros; Refine pair;
    Intros _; Refine H1.fst;
      Refine LessEq_antisym H1.snd;
      Refine extenRel ? H4 ?.Eq_refl; Refine H;
    Refine LessEq_trans ? H H3;
  Save LessEqLess_trans;

  Goal {x|el A}{y:el A}{z|el A}
       (Less.ap2 x y) -> (LessEq.ap2 y z) -> (Less.ap2 x z);
    intros; Refine H;
    intros; Refine pair;
    Intros _; Refine H.fst;
      Refine LessEq_antisym H.snd;
      Refine extenRel ? ?.Eq_refl H4.Eq_sym; Refine H1;
    Refine LessEq_trans ? H3 H1;
  Save LessLessEq_trans;

  [A_discr : Discrete A];

  Goal {x,y:el A} or3 (Less.ap2 x y) (Eq x y) (Less.ap2 y x);
    intros;
    orE A_discr x y;
    Refine or3_in2;
    intros; orE LessEq_total x y;
    intros; Refine or3_in1; Refine pair H H1;
    intros; Refine or3_in3; Refine pair ? H1;
    Intros _; Refine H; Refine Eq_sym H2;
  Save Less_partit;

  Goal LessEq_partit
    : {x,y:el A} (LessEq.ap2 x y) \/ (Less.ap2 y x);
    intros; Refine Less_partit x y;
    intros; Refine inl; Refine H.snd;
    intros; Refine inl; Refine extenRel ? ?.Eq_refl H ?.LessEq_refl;
    Refine inr;
  Save;

  Goal DecidableRel LessEq;
    Intros __;
    orE LessEq_partit x y;
    Refine inl;
    intros; Refine inr; Refine Less_elim H;
  Save LessEq_dec;

  Goal {x,y|el A} (LessEq.ap2 x y) -> ((Eq x y) \/ (Less.ap2 x y));
    intros;
    orE A_discr x y;
    Refine inl;
    intros; Refine inr; Refine pair H1 H;
  Save LessEq2Less;

  Goal {x,y|el A} ~(Less.ap2 x y) -> LessEq.ap2 y x;
    intros;
    orE LessEq_partit y x;
    Refine Id;
    intros; Refine H H1;
  Save LessEq_intro;

  Goal {x,y|el A} ~(LessEq.ap2 x y) -> Less.ap2 y x;
    intros;
    orE LessEq_partit x y;
    intros; Refine H H1;
    Refine Id;
  Save Less_intro;

  Goal DecidableRel Less;
    Intros x y; Refine Less_partit x y;
    Refine inl;
    intros; Refine inr; Intros _; Refine H1.fst H;
    intros; Refine inr; Refine Less_antisym H;
  Save Less_dec;

  Discharge A_discr;

  Goal {f|Fun A A} (Injection f) ->
       (preserve1 LessEq.ap2 LessEq.ap2 f.ap) ->
       (preserve1 Less.ap2   Less.ap2   f.ap);
    Intros ______;
    Refine pair;
    Intros _; Refine H2.fst; Refine H H3;
    Refine H1 H2.snd;
  Save Less_pres1;

  Goal {f|Fun A A}
       ({x,y|el A}(LessEq.ap2 (f.ap x) (f.ap y)) -> LessEq.ap2 x y) ->
       ({x,y|el A}(Less.ap2   (f.ap x) (f.ap y)) -> Less.ap2   x y);
    intros;
    Refine pair;
    Intros _; Refine H1.fst; Refine exten ? H2;
    Refine H H1.snd;
  Save Less_inj;

(* ------------------------------------------------------------------------------
   Define the maximum function.
*)

  [     max : A.el -> A.el -> A.el
            = [x,y:el A] select (LessEq_total x y) y x
  ];

  Goal {x,y:el A} (LessEq.ap2 x y) -> (LessEq.ap2 y x) -> Eq y x;
    intros; Refine LessEq_antisym H1 H;
  Save max_ok;

  Goal extensional2 max;
    Intros ______;
    Refine LessEq_total x y;
    intros;
      Refine Eq_trans y; Refine select_left (max_ok x y) H2;
      Refine Eq_trans y'; Refine H1;
      Refine Eq_sym; Refine select_left (max_ok x' y');
      Refine extenRel LessEq H H1 H2;
    intros;
      Refine Eq_trans x; Refine select_right (max_ok x y) H2;
      Refine Eq_trans x'; Refine H;
      Refine Eq_sym; Refine select_right (max_ok x' y');
      Refine extenRel LessEq H1 H H2;
  Save max_exten;

  [     Max : Fun2 A A A
            = Fun2_intro max max_exten
  ];

  Goal Max_lemma2r : {x,y|el A} (LessEq.ap2 x y) -> Eq (Max.ap2 x y) y;
    intros __;
    Refine select_left (max_ok x y);
  Save;

  Goal Max_lemma2l : {x,y|el A} (LessEq.ap2 y x) -> Eq (Max.ap2 x y) x;
    intros __;
    Refine select_right (max_ok x y);
  Save;

  Goal {a,x,y|el A} (LessEq.ap2 a x) -> (LessEq.ap2 a (Max.ap2 x y));
    intros; Refine LessEq_total x y;
    intros; Refine extenRel ? ?.Eq_refl (Max_lemma2r H1).Eq_sym;
      Refine LessEq_trans ? H H1;
    intros; Refine extenRel ? ?.Eq_refl (Max_lemma2l H1).Eq_sym;
      Refine H;
  Save lMax_LessEq_low_intro;

  Goal {a,x,y|el A} (Less.ap2 a x) -> (Less.ap2 a (Max.ap2 x y));
    intros; Refine LessEq_total x y;
    intros; Refine extenRel ? ?.Eq_refl (Max_lemma2r H1).Eq_sym;
      Refine LessLessEq_trans ? H H1;
    intros; Refine extenRel ? ?.Eq_refl (Max_lemma2l H1).Eq_sym;
      Refine H;
  Save lMax_Less_low_intro;

  Goal {a,x,y|el A} (LessEq.ap2 a y) -> (LessEq.ap2 a (Max.ap2 x y));
    intros; Refine LessEq_total x y;
    intros; Refine extenRel ? ?.Eq_refl (Max_lemma2r H1).Eq_sym;
      Refine H;
    intros; Refine extenRel ? ?.Eq_refl (Max_lemma2l H1).Eq_sym;
      Refine LessEq_trans ? H H1;
  Save rMax_LessEq_low_intro;

  Goal {a,x,y|el A} (Less.ap2 a y) -> (Less.ap2 a (Max.ap2 x y));
    intros; Refine LessEq_total x y;
    intros; Refine extenRel ? ?.Eq_refl (Max_lemma2r H1).Eq_sym;
      Refine H;
    intros; Refine extenRel ? ?.Eq_refl (Max_lemma2l H1).Eq_sym;
      Refine LessLessEq_trans ? H H1;
  Save rMax_Less_low_intro;

  Goal {a,x,y|el A} (LessEq.ap2 a (Max.ap2 x y)) ->
                    ((LessEq.ap2 a x) \/ (LessEq.ap2 a y));
    intros; Refine LessEq_total x y;
    intros; Refine inr; Refine extenRel ? ?.Eq_refl (Max_lemma2r H1) H;
    intros; Refine inl; Refine extenRel ? ?.Eq_refl (Max_lemma2l H1) H;
  Save Max_LessEq_low_elim;

  Goal {a,x,y|el A} (Less.ap2 a (Max.ap2 x y)) -> ((Less.ap2 a x) \/ (Less.ap2 a y));
    intros; Refine LessEq_total x y;
    intros; Refine inr; Refine extenRel ? ?.Eq_refl (Max_lemma2r H1) H;
    intros; Refine inl; Refine extenRel ? ?.Eq_refl (Max_lemma2l H1) H;
  Save Max_Less_low_elim;

  Goal {x,y,a|el A} (LessEq.ap2 x a) -> (LessEq.ap2 y a) ->
                    (LessEq.ap2 (Max.ap2 x y) a);
    intros; Refine LessEq_total x y;
    intros; Refine extenRel ? (Max_lemma2r H2).Eq_sym ?.Eq_refl H1;
    intros; Refine extenRel ? (Max_lemma2l H2).Eq_sym ?.Eq_refl H;
  Save Max_LessEq_high_intro;

  Goal {x,y,a|el A} (Less.ap2 x a) -> (Less.ap2 y a) -> (Less.ap2 (Max.ap2 x y) a);
    intros; Refine LessEq_total x y;
    intros; Refine extenRel ? (Max_lemma2r H2).Eq_sym ?.Eq_refl H1;
    intros; Refine extenRel ? (Max_lemma2l H2).Eq_sym ?.Eq_refl H;
  Save Max_Less_high_intro;

  Goal {x,y,a|el A} (LessEq.ap2 (Max.ap2 x y) a) -> (LessEq.ap2 x a);
    intros; Refine LessEq_total x y;
    intros; Refine LessEq_trans ? H1;
      Refine extenRel ? (Max_lemma2r H1) ?.Eq_refl H;
    intros; Refine extenRel ? (Max_lemma2l H1) ?.Eq_refl H;
  Save lMax_LessEq_high_elim;

  Goal {x,y,a|el A} (Less.ap2 (Max.ap2 x y) a) -> (Less.ap2 x a);
    intros; Refine LessEq_total x y;
    intros; Refine LessEqLess_trans ? H1;
      Refine extenRel ? (Max_lemma2r H1) ?.Eq_refl H;
    intros; Refine extenRel ? (Max_lemma2l H1) ?.Eq_refl H;
  Save lMax_Less_high_elim;

  Goal {x,y,a|el A} (LessEq.ap2 (Max.ap2 x y) a) -> (LessEq.ap2 y a);
    intros; Refine LessEq_total x y;
    intros; Refine extenRel ? (Max_lemma2r H1) ?.Eq_refl H;
    intros; Refine LessEq_trans ? H1;
      Refine extenRel ? (Max_lemma2l H1) ?.Eq_refl H;
  Save rMax_LessEq_high_elim;

  Goal {x,y,a|el A} (Less.ap2 (Max.ap2 x y) a) -> (Less.ap2 y a);
    intros; Refine LessEq_total x y;
    intros; Refine extenRel ? (Max_lemma2r H1) ?.Eq_refl H;
    intros; Refine LessEqLess_trans ? H1;
      Refine extenRel ? (Max_lemma2l H1) ?.Eq_refl H;
  Save rMax_Less_high_elim;

  Goal {x,y:el A} LessEq.ap2 x (Max.ap2 y x);
    intros;
    Refine rMax_LessEq_low_intro ?.LessEq_refl;
  Save Max_lemma1r;

  Goal {x,y:el A} LessEq.ap2 x (Max.ap2 x y);
    intros;
    Refine lMax_LessEq_low_intro ?.LessEq_refl;
  Save Max_lemma1l;

  Goal preserve2 LessEq.ap2 LessEq.ap2 LessEq.ap2 Max.ap2;
    Intros ______;
    Refine LessEq_total x y;
    intros;
      Refine LessEq_trans y;
        Refine Max_LessEq_high_intro H2 ?.LessEq_refl;
      Refine LessEq_trans ? H1; Refine Max_lemma1r;
    intros;
      Refine LessEq_trans x;
        Refine Max_LessEq_high_intro ?.LessEq_refl H2;
      Refine LessEq_trans ? H; Refine Max_lemma1l;
  Save Max_pres_LessEq;

  Goal preserve2 Less.ap2 Less.ap2 Less.ap2 Max.ap2;
    Intros ______;
    Refine LessEq_total x y;
    intros;
      Refine LessEqLess_trans y;
        Refine Max_LessEq_high_intro H2 ?.LessEq_refl;
      Refine LessLessEq_trans ? H1; Refine Max_lemma1r;
    intros;
      Refine LessEqLess_trans x;
        Refine Max_LessEq_high_intro ?.LessEq_refl H2;
      Refine LessLessEq_trans ? H; Refine Max_lemma1l;
  Save Max_pres_Less;

  Goal Max_idempot : Idempotent Max;
    Intros x;
    Refine Max_lemma2r; Refine LessEq_refl;
  Save;

  Goal Max_commut : Commutative Max;
    Intros x y;
    Refine LessEq_total x y;
    intros; Refine Eq_trans y;
      Refine Max_lemma2r H; Refine Eq_sym; Refine Max_lemma2l H;
    intros; Refine Eq_trans x;
      Refine Max_lemma2l H; Refine Eq_sym; Refine Max_lemma2r H;
  Save;

  Goal Max_assoc : Associative Max;
    Intros x y z;
    Refine select_lemma ([u:el A] Eq (Max.ap2 x (Max.ap2 y z)) (Max.ap2 u z));

    intros;
    Refine select_lemma ([u:el A] Eq (Max.ap2 x u) u);
    intros;
    Refine Max_lemma2r; Refine LessEq_trans ? H H1;
    intros;
    Refine Max_lemma2r H;

    intros;
    Refine select_lemma ([u:el A] Eq (Max.ap2 x u) (Max.ap2 x z));
    intros; Refine Eq_refl;
    intros; Refine Eq_trans x;
    Refine Max_lemma2l H;
    Refine Eq_sym; Refine Max_lemma2l; Refine LessEq_trans ? H1 H;
  Save;

(* --------------------------------------------------------------------------------
   Define the minimum function.
*)

[     min : A.el -> A.el -> A.el
          = [x,y:el A] select (LessEq_total x y) x y
];

Goal extensional2 min;
  Intros ______;
  Refine select_lemma ([z:el A] Eq z (min x' y'));
  intros;
  Refine select_lemma ([z:el A] Eq x z);
  intros; Immed;
  intros; Refine LessEq_antisym;
    Refine extenRel LessEq x.Eq_refl H1 H2;
    Refine extenRel LessEq y'.Eq_refl H.Eq_sym H3;
  intros;
  Refine select_lemma ([z:el A] Eq y z);
  intros; Refine LessEq_antisym;
    Refine extenRel LessEq y.Eq_refl H H2;
    Refine extenRel LessEq x'.Eq_refl H1.Eq_sym H3;
  intros; Immed;
Save min_exten;

[     Min : Fun2 A A A
          = Fun2_intro min min_exten
];

Goal Min_idempot : Idempotent Min;
  Intros x;
  Refine select_lemma ([z:el A] Eq z x);
  Refine ?+1; intros; Refine Eq_refl;
Save;

Goal {x,y:el A} LessEq.ap2 (Min.ap2 x y) x;
  intros;
  Refine select_lemma ([z:el A] LessEq.ap2 z x);
  intros; Refine LessEq_refl;
  Refine Id;
Save Min_lemma1l;

Goal Min_commut : Commutative Min;
  Intros x y;
  Refine select_lemma ([u:el A] Eq u (Min.ap2 y x));
  intros; Refine select_lemma ([u:el A] Eq x u);
  intros; Refine LessEq_antisym H H1;
  intros; Refine Eq_refl;
  intros; Refine select_lemma ([u:el A] Eq y u);
  intros; Refine Eq_refl;
  intros; Refine LessEq_antisym H H1;
Save;

(* --------------------------------------------------------------------------------
   Mimimum / Maximum
*)

Goal MinMax_absorb : {x,y:el A} Eq (Min.ap2 (Max.ap2 x y) x) x;
  intros; Refine select_lemma ([u:el A] Eq (Min.ap2 u x) x);
  intros; Refine select_lemma ([u:el A] Eq u x);
  intros; Refine LessEq_antisym H1 H;
  intros; Refine Eq_refl;
  intros; Refine Min_idempot;
Save;

Discharge A;

(* PS. Some proofs concerning the minimum and maximum could be simplified. *)

