
Module Complex Import Real SqrtR;

(* 
   Define the Complex numbers. We chose to represent these as
   Cartesian coordinates.
*)

[     Cplx : Set
          = Prod Real Real
];

(* --------------------------------------------------------------------------------
   Define operators and functions to extract the real and
   imaginary part of a complex number.
*)

Goal re : Cplx.el ->  Real.el;
  Refine First;
Save;

Goal Re : Fun Cplx Real;
  Refine Fun_intro re;
  Intros __; Refine fst;
Save;

Goal im : Cplx.el ->  Real.el;
  Refine Second;
Save;

Goal Im : Fun Cplx Real;
  Refine Fun_intro im;
  Intros __; Refine snd;
Save;

Goal cart : Real.el -> Real.el -> Cplx.el;
  Refine Tuple;
Save;

Goal Cart : Fun2 Real Real Cplx;
  Refine Fun2_intro cart;
  Intros _____; Refine pair H;
Save;

Goal eq_cplx_elim : {x,y|el Cplx} (Eq x y) -> and (Eq x.re y.re) (Eq x.im y.im);
  intros __;
  Refine Id;
Save;

Goal eq_cplx_intro : {x,y|el Cplx} (Eq x.re y.re) -> (Eq x.im y.im) -> Eq x y;
  intros __;
  Refine pair;
Save;

(* --------------------------------------------------------------------------------
   Define the predicates 'is real' and 'is purly imaginary'.
*)

[is_real [x:el Cplx] = Eq (Im.ap x) ZeroR];
[is_pure_im [x:el Cplx] = ~(Eq (Im.ap x) ZeroR)];

Goal IsReal : Pred Cplx;
  Refine Pred_intro is_real;
  Intros; Refine Eq_trans (Im.ap x); Refine exten ? H.Eq_sym; Refine H1;
Save;

Goal IsPureIm : Pred Cplx;
  Refine Pred_intro is_pure_im;
  Intros _____; Refine H1; Refine extenPred IsReal H.Eq_sym H2;
Save;

Goal DecidablePred IsReal;
  Intros _;
  Refine Real_discr x.im ZeroR;
Save IsReal_dec;

Goal DecidablePred IsPureIm;
  Intros _;
  orE Real_discr x.im ZeroR;
  intros; Refine inr; Intros _; Refine H1 H;
  Refine inl;
Save IsPureIm_dec;

(* --------------------------------------------------------------------------------
   Because the reals are assumed to be discrete, the complex numbers
   are also discrete.
*)

Goal Cplx_discr : Discrete Cplx;
  Refine Prod_discr Real_discr Real_discr;
Save;

Freeze Cplx; (* Speeds up a lot the checking of for example complex polynomials. *)

(* --------------------------------------------------------------------------------
   Given a real, coerce it to a complex number.
*)

[     cp : Real.el -> Cplx.el
          = [x:el Real] cart x ZeroR
]
[     Cp : Fun Real Cplx
          = Fun_intro cp ([x,x':el Real][H:Eq x x'] Cart.exten2 H ?.Eq_refl)
]
[     cpi: Real.el -> Cplx.el
          = [x:el Real] cart ZeroR x
]
[     Cpi: Fun Real Cplx
          = Fun_intro cpi ([x,x':el Real][H:Eq x x'] Cart.exten2 ?.Eq_refl H)
];

Goal {x:el Cplx} (IsReal.ap x) -> Eq x.re.cp x;
  intros;
  Refine eq_cplx_intro; Refine Eq_refl; Refine Eq_sym H;
Save Cp_lemma;

Goal Cp_inj : Injection Cp;
  Intros ___; Refine (eq_cplx_elim H).fst;
Save;

(* --------------------------------------------------------------------------------
   Build the group of complex numbers.
*)

[     ZeroC : el Cplx
          = cp ZeroR
]
[     OneC : el Cplx
          = cp OneR
]
[     I : el Cplx
          = cpi OneR
];

Goal plusC : Cplx.el -> Cplx.el -> Cplx.el;
  Refine [x,y:el Cplx] cart (PlusR.ap2 x.re y.re) (PlusR.ap2 x.im y.im);
Save;

Goal PlusC : Fun2 Cplx Cplx Cplx;
  Refine Fun2_intro;
  Refine plusC;
  Intros ______; Refine eq_cplx_intro;
  Refine exten2; Refine exten Re H; Refine exten Re H1;
  Refine exten2; Refine exten Im H; Refine exten Im H1;
Save;

Goal negC : Cplx.el -> Cplx.el;
  Refine [x:el Cplx] cart (NegR.ap x.re) (NegR.ap x.im);
Save;

Goal NegC : Fun Cplx Cplx;
  Refine Fun_intro;
  Refine negC;
  Intros ___; Refine eq_cplx_intro;
  Refine exten; Refine exten Re H;
  Refine exten; Refine exten Im H;
Save;

Goal PlusC_assoc : Associative PlusC;
  Intros x y z; Refine eq_cplx_intro; Refine PlusR_assoc; Refine PlusR_assoc;
Save;

Goal rZeroC_ident : rIdentity PlusC ZeroC;
  Intros x; Refine eq_cplx_intro; Refine rZeroR_ident; Refine rZeroR_ident;
Save;

Goal rNegC_invers : rInverse PlusC ZeroC NegC;
  Intros x; Refine eq_cplx_intro; Refine rNegR_invers; Refine rNegR_invers;
Save;

(* --------------------------------------------------------------------------------
   Build the ring of complex numbers.
*)

Goal PlusC_commut : Commutative PlusC;
  Intros x y; Refine eq_cplx_intro; Refine PlusR_commut; Refine PlusR_commut;
Save;

Goal timesC : Cplx.el -> Cplx.el -> Cplx.el;
  Refine [x,y:el Cplx]
         cart  (MinusR.ap2 (TimesR.ap2 x.re y.re) (TimesR.ap2 x.im y.im))
               (PlusR.ap2  (TimesR.ap2 x.re y.im) (TimesR.ap2 x.im y.re));
Save;

Goal TimesC : Fun2 Cplx Cplx Cplx;
  Refine Fun2_intro;
  Refine timesC;
  Intros ______; Refine eq_cplx_intro;
  Refine exten2; Refine exten2; Refine exten Re H; Refine exten Re H1;
                 Refine exten2; Refine exten Im H; Refine exten Im H1;
  Refine exten2; Refine exten2; Refine exten Re H; Refine exten Im H1;
                 Refine exten2; Refine exten Im H; Refine exten Re H1;
Save;

Goal TimesC_assoc : Associative TimesC;
  Intros x y z;
  [x1 = re x][x2 = im x][y1 = re y]
  [y2 = im y][z1 = re z][z2 = im z];
  Refine eq_cplx_intro;
  [K = TimesR.ap2 (TimesR.ap2 x1 y1) z1] [L = TimesR.ap2 (TimesR.ap2 x1 y2) z2]
  [M = TimesR.ap2 (TimesR.ap2 x2 y1) z2] [N = TimesR.ap2 (TimesR.ap2 x2 y2) z1];
  Equiv Eq
        (MinusR.ap2 (TimesR.ap2 x1 (MinusR.ap2 (TimesR.ap2 y1 z1) (TimesR.ap2 y2 z2)))
                    (TimesR.ap2 x2 (PlusR.ap2  (TimesR.ap2 y1 z2) (TimesR.ap2 y2 z1))))
        (MinusR.ap2 (TimesR.ap2 (MinusR.ap2 (TimesR.ap2 x1 y1) (TimesR.ap2 x2 y2)) z1)
                    (TimesR.ap2 (PlusR.ap2  (TimesR.ap2 x1 y2) (TimesR.ap2 x2 y1)) z2));
  Refine Eq_trans (MinusR.ap2 (MinusR.ap2 (TimesR.ap2 x1 (TimesR.ap2 y1 z1))
                              (TimesR.ap2 x1 (TimesR.ap2 y2 z2)))
                  (PlusR.ap2  (TimesR.ap2 x2 (TimesR.ap2 y1 z2))
                              (TimesR.ap2 x2 (TimesR.ap2 y2 z1))));
    Refine exten2 PlusR; Refine lTimesMinusR_distrib;
    Refine exten; Refine lTimesPlusR_distrib;
  Refine Eq_trans (MinusR.ap2 (MinusR.ap2 K L) (PlusR.ap2 M N));
    Refine exten2; Refine exten2; Refine TimesR_assoc; Refine TimesR_assoc;
                   Refine exten2; Refine TimesR_assoc; Refine TimesR_assoc;
  Refine Eq_trans (PlusR.ap2 K (MinusR.ap2 (NegR.ap L) (PlusR.ap2 M N)));
    Refine Eq_sym; Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 K (MinusR.ap2 (NegR.ap N) (PlusR.ap2 L M)));
    Refine exten2; Refine Eq_refl;
  Refine Eq_trans (NegR.ap (PlusR.ap2 L (PlusR.ap2 M N)));
    Refine PlusNegR_distrib;
  Refine Eq_trans (NegR.ap (PlusR.ap2 N (PlusR.ap2 L M)));
    Refine +1 Eq_sym; Refine +1 PlusNegR_distrib;
  Refine exten;
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 L M ) N);
    Refine PlusR_assoc; Refine PlusR_commut;
  Refine Eq_trans (MinusR.ap2 (MinusR.ap2 K N) (PlusR.ap2 L M));
    Refine PlusR_assoc;
  Refine exten2;
  Refine Eq_sym; Refine rTimesMinusR_distrib;
  Refine Eq_sym; Refine rTimesPlusR_distrib;

  [K' = TimesR.ap2 (TimesR.ap2 x1 y1) z2] [L' = TimesR.ap2 (TimesR.ap2 x1 y2) z1]
  [M' = TimesR.ap2 (TimesR.ap2 x2 y1) z1] [N' = TimesR.ap2 (TimesR.ap2 x2 y2) z2];
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2  (TimesR.ap2 x1 (TimesR.ap2 y1 z2))
                                         (TimesR.ap2 x1 (TimesR.ap2 y2 z1)))
                             (MinusR.ap2 (TimesR.ap2 x2 (TimesR.ap2 y1 z1))
                                         (TimesR.ap2 x2 (TimesR.ap2 y2 z2))));
  Refine exten2; Refine lTimesPlusR_distrib; Refine lTimesMinusR_distrib;
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 K' L') (MinusR.ap2 M' N'));
  Refine exten2; Refine exten2; Refine TimesR_assoc; Refine TimesR_assoc;
                 Refine exten2; Refine TimesR_assoc; Refine TimesR_assoc;
  Refine Eq_trans (PlusR.ap2 K' (PlusR.ap2 L' (MinusR.ap2 M' N')));
    Refine Eq_sym; Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 (MinusR.ap2 K' N') (PlusR.ap2 L' M'));
  Refine Eq_trans (PlusR.ap2 K' (PlusR.ap2 (NegR.ap N') (PlusR.ap2 L' M')));
    Refine +1 PlusR_assoc;
  Refine exten2; Refine Eq_refl;
  Refine Eq_trans (MinusR.ap2 (PlusR.ap2 L' M') N');
     Refine PlusR_assoc; Refine PlusR_commut;
  Refine exten2; Refine Eq_sym; Refine rTimesMinusR_distrib;
                 Refine Eq_sym; Refine rTimesPlusR_distrib;
Save;

Goal TimesC_commut : Commutative TimesC;
  Intros x y;
  [x1 = re x][x2 = im x][y1 = re y][y2 = im y];
  Refine eq_cplx_intro;
  Equiv Eq (MinusR.ap2 (TimesR.ap2 x1 y1) (TimesR.ap2 x2 y2))
           (MinusR.ap2 (TimesR.ap2 y1 x1) (TimesR.ap2 y2 x2));
  Refine exten2; Refine TimesR_commut; Refine TimesR_commut;
  Equiv Eq (PlusR.ap2 (TimesR.ap2 x1 y2) (TimesR.ap2 x2 y1))
           (PlusR.ap2 (TimesR.ap2 y1 x2) (TimesR.ap2 y2 x1));
  Refine Eq_trans (PlusR.ap2 (TimesR.ap2 x2 y1) (TimesR.ap2 x1 y2));
    Refine PlusR_commut;
  Refine exten2; Refine TimesR_commut; Refine TimesR_commut;
Save;

Goal rOneC_ident : rIdentity TimesC OneC;
  Intros x; Refine eq_cplx_intro;
  Equiv Eq (MinusR.ap2 (TimesR.ap2 x.re OneR) (TimesR.ap2 x.im ZeroR)) x.re;
  Refine Eq_trans (MinusR.ap2 (TimesR.ap2 x.re OneR) ZeroR);
    Refine exten2; Refine Eq_refl; Refine rTimesZeroR;
  Refine Eq_trans (TimesR.ap2 x.re OneR);
     Refine rNegZeroR_ident; Refine rOneR_ident;
  Equiv Eq (PlusR.ap2 (TimesR.ap2 x.re ZeroR) (TimesR.ap2 x.im OneR)) x.im;
  Refine Eq_trans (PlusR.ap2 ZeroR (TimesR.ap2 x.im OneR));
    Refine exten2; Refine rTimesZeroR; Refine Eq_refl;
  Refine Eq_trans (TimesR.ap2 x.im OneR);
    Refine lZeroR_ident;
  Refine rOneR_ident;
Save;

Goal rTimesPlusC_distrib : rDistributive PlusC TimesC;
  Intros a x y;
  [x1 = re x][x2 = im x][y1 = re y]
  [y2 = im y][a1 = re a][a2 = im a];
  Refine eq_cplx_intro;
  [K = TimesR.ap2 x1 a1] [L = TimesR.ap2 x2 a2]
  [M = TimesR.ap2 y1 a1] [N = TimesR.ap2 y2 a2];
  Refine Eq_trans (MinusR.ap2 (PlusR.ap2 K M) (PlusR.ap2 L N));
    Refine exten2; Refine rTimesPlusR_distrib; Refine rTimesPlusR_distrib;
  Refine Eq_trans (PlusR.ap2 K (MinusR.ap2 M (PlusR.ap2 L N)));
    Refine Eq_sym; Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 K (PlusR.ap2 (NegR.ap L) (MinusR.ap2 M N)));
    Refine +1 PlusR_assoc;
  Refine exten2; Refine Eq_refl;
  Refine Eq_trans (PlusR.ap2 M (MinusR.ap2 (NegR.ap L) N));
    Refine exten2 PlusR; Refine Eq_refl; Refine Eq_sym; Refine PlusNegR_distrib;
  Refine Eq_trans (MinusR.ap2 (MinusR.ap2 M L) N);
    Refine PlusR_assoc;
  Refine Eq_trans (MinusR.ap2 (PlusR.ap2 (NegR.ap L) M) N);
    Refine exten2; Refine +1 Eq_refl; Refine PlusR_commut;
  Refine Eq_sym; Refine PlusR_assoc;

  [K' = TimesR.ap2 x1 a2] [L' = TimesR.ap2 x2 a1]
  [M' = TimesR.ap2 y1 a2] [N' = TimesR.ap2 y2 a1];
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 K' M') (PlusR.ap2 L' N'));
    Refine exten2; Refine rTimesPlusR_distrib; Refine rTimesPlusR_distrib;
  Refine Eq_trans (PlusR.ap2 K' (PlusR.ap2 M' (PlusR.ap2 L' N')));
    Refine Eq_sym; Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 K' (PlusR.ap2 L' (PlusR.ap2 M' N')));
    Refine +1 PlusR_assoc;
  Refine exten2; Refine Eq_refl;
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 M' L') N');
    Refine PlusR_assoc;
  Refine Eq_trans (PlusR.ap2 (PlusR.ap2 L' M') N');
    Refine exten2; Refine PlusR_commut; Refine Eq_refl;
  Refine Eq_sym; Refine PlusR_assoc;
Save;

(* --------------------------------------------------------------------------------
   Build the field of complex numbers.
*)

Goal RecipC : Fun Cplx Cplx;
  Refine Fun_intro;
  Intros x;
    [x1 = re x] [x2 = im x]
    [D = PlusR.ap2 (SquareR.ap x1) (SquareR.ap x2)];
    Refine cart (DivR.ap2 x1 D) (NegR.ap (DivR.ap2 x2 D));
  Intros ___; andE eq_cplx_elim H; Refine eq_cplx_intro;
  Refine exten2 ? H1; Refine exten2; Refine exten2 ? H1 H1; Refine exten2 ? H2 H2;
  Refine exten;
  Refine exten2 ? H2; Refine exten2; Refine exten2 ? H1 H1; Refine exten2 ? H2 H2;
Save;

Goal RecipC_invers : MultInverse TimesC ZeroC OneC RecipC;
  Intros _; Refine pair;
  intros;
    [x1   = re x]             [x2   = im x]
    [x1x1 = SquareR.ap x1]    [x2x2 = SquareR.ap x2]
    [x1x2 = TimesR.ap2 x1 x2] [x2x1 = TimesR.ap2 x2 x1]
    [D = PlusR.ap2 x1x1 x2x2];
    Refine eq_cplx_intro;

    Equiv Eq (MinusR.ap2 (TimesR.ap2 x1 (DivR.ap2 x1 D))
                         (TimesR.ap2 x2 (NegR.ap (DivR.ap2 x2 D)))) OneR;
    Refine Eq_trans (PlusR.ap2 (DivR.ap2 x1x1 D) (DivR.ap2 x2x2 D));
      Refine exten2 PlusR; Refine TimesR_assoc;
    Refine Eq_trans (NegR.ap (NegR.ap (TimesR.ap2 x2 (DivR.ap2 x2 D))));
      Refine exten; Refine rTimesNegR_distrib;
    Refine Eq_trans (TimesR.ap2 x2 (DivR.ap2 x2 D));
      Refine NegR_invol;
    Refine TimesR_assoc;

    Refine Eq_trans (DivR.ap2 D D);
      Refine Eq_sym; Refine REAL.rTimesPlusFd_distrib;
    Refine rRecipR_invers; Intros _; Refine H; andE PlusSquareR_zero H1;
      Refine eq_cplx_intro; Refine H2; Refine H3;

    Equiv Eq (PlusR.ap2 (TimesR.ap2 x1 (NegR.ap (DivR.ap2 x2 D)))
                        (TimesR.ap2 x2 (DivR.ap2 x1 D))) ZeroR;
    Refine Eq_trans (PlusR.ap2 (DivR.ap2 (NegR.ap x1x2) D) (DivR.ap2 x2x1 D));
      Refine exten2; Refine +1 TimesR_assoc;
      Refine Eq_trans (NegR.ap (TimesR.ap2 x1 (DivR.ap2 x2 D)));
        Refine rTimesNegR_distrib;
      Refine Eq_trans (NegR.ap (DivR.ap2 x1x2 D));
        Refine exten; Refine TimesR_assoc;
      Refine Eq_sym; Refine lTimesNegR_distrib;
    Refine Eq_trans (DivR.ap2 (PlusR.ap2 (NegR.ap x1x2) x2x1) D);
      Refine Eq_sym; Refine rTimesPlusR_distrib;
    Refine Eq_trans (DivR.ap2 ZeroR D);
      Refine exten2; Refine +1 Eq_refl; Refine +1 lTimesZeroR;
    Refine Eq_trans (PlusR.ap2 (NegR.ap x1x2) x1x2);
      Refine exten2; Refine Eq_refl; Refine TimesR_commut;
    Refine lNegR_invers;

  intros;
    Refine Ring_Field_lemma1 
           (Ring_intro Cplx PlusC TimesC NegC ZeroC OneC
                       PlusC_assoc PlusC_commut rZeroC_ident rNegC_invers
                       TimesC_assoc (Identity_intro TimesC_commut rOneC_ident)
                       (Distributive_intro TimesC_commut rTimesPlusC_distrib))
           ? RecipC H;
    Intros _; andE eq_cplx_elim H1; Refine Field_non_trivial REAL H2;
Save;

[     COMPLEX : Field
          = Field_intro PlusC_assoc PlusC_commut rZeroC_ident rNegC_invers
                        TimesC_assoc TimesC_commut rOneC_ident RecipC_invers
                        rTimesPlusC_distrib
]
[     COMPLEX_Group : Group
          = COMPLEX.GroupFd
]
[     COMPLEX_Ring : Ring
          = COMPLEX.RingFd
];

Freeze PlusC_assoc PlusC_commut rZeroC_ident rNegC_invers
       TimesC_assoc TimesC_commut rOneC_ident RecipC_invers
       rTimesPlusC_distrib;

[     MinusC : Fun2 Cplx Cplx Cplx
          = COMPLEX.MinusFd
];

[     DivC : Fun2 Cplx Cplx Cplx
          = COMPLEX.DivFd
];

(* ================================================================================
   Because C is a field, we get a lot of functins and lemma's for
   free. Import these.
*)

Goal ~(Eq OneC ZeroC);
  Refine OneFd_not_zero COMPLEX;
Save OneC_not_zero;

Goal NegC_invol : Involutive NegC;
  Refine COMPLEX_Group.InvGr_invol;
Save;

Goal rTimesZeroC : {x:el Cplx} Eq (TimesC.ap2 x ZeroC) ZeroC;
  Refine COMPLEX.rTimesZeroFd;
Save;

Goal lTimesZeroC : {x:el Cplx} Eq (TimesC.ap2 ZeroC x) ZeroC;
  Refine COMPLEX.lTimesZeroFd;
Save;

Goal {x,y:el Cplx} (Eq (TimesC.ap2 x y) ZeroC) -> (Eq x ZeroC) \/ (Eq y ZeroC);
  Refine TimesFd_zero COMPLEX Cplx_discr;
Save TimesC_zero;

Goal Eq (RecipC.ap OneC) OneC;
  Refine RecipOneFd COMPLEX;
Save RecipOneC;

Goal rRecipC_invers : {x|el Cplx} ~(Eq x ZeroC) ->
                                   (Eq (TimesC.ap2 x (RecipC.ap x)) OneC);
  Refine COMPLEX.rRecipFd_invers;
Save;

Goal lRecipC_invers : {x|el Cplx} ~(Eq x ZeroC) ->
                                   (Eq (TimesC.ap2 (RecipC.ap x) x) OneC);
  Refine COMPLEX.lRecipFd_invers;
Save;

(* --------------------------------------------------------------------------------
   Define the power of a complex numer.
*)

[     PowerC : Fun2 Cplx Nat Cplx
          = COMPLEX_Ring.PowerRg
];

Goal PowerC_plus : {x:el Cplx}{m,n:el Nat} Eq (PowerC.ap2 x (PlusN.ap2 m n))
                              (TimesC.ap2 (PowerC.ap2 x m) (PowerC.ap2 x n));
  Refine COMPLEX_Ring.PowerRg_plus;
Save;

Goal PowerC_times : {x:el Cplx}{m,n:el Nat} Eq (PowerC.ap2 x (TimesN.ap2 m n))
                                  (PowerC.ap2 (PowerC.ap2 x m) n);
  Refine COMPLEX_Ring.PowerRg_times;
Save;

Goal PowerC_distrib : {x,y:el Cplx}{n:el Nat} Eq (PowerC.ap2 (TimesC.ap2 x y) n)
                                   (TimesC.ap2 (PowerC.ap2 x n) (PowerC.ap2 y n));
  Refine COMPLEX_Ring.PowerRg_distrib;
  Refine TimesC_commut;
Save;

(* --------------------------------------------------------------------------------
   Define the square of a complex numer.
*)

[     SquareC : Fun Cplx Cplx
          = COMPLEX_Ring.SquareRg
];

Goal SquareTimesC
   : {x,y:el Cplx} Eq (SquareC.ap (TimesC.ap2 x y))
                      (TimesC.ap2 (SquareC.ap x) (SquareC.ap y));
  Refine COMPLEX.SquareTimesFd;
Save;

Goal {x:el Cplx} (Eq (SquareC.ap x) ZeroC) -> Eq x ZeroC;
  Refine SquareFd_zero COMPLEX Cplx_discr;
Save SquareC_zero;

(* ================================================================================
   Now start to prove a list of lemma's wich only holds for complex numbers.
*)

(*    2         2        2
     x    =  (re (x) - im (x)) + (2 re(x) im(x)) i
*)

Goal {x:el Cplx} Eq (SquareC.ap x)
                    (Cart.ap2 (MinusR.ap2 (SquareR.ap (Re.ap x)) (SquareR.ap (Im.ap x)))
                              (DoubleR.ap (TimesR.ap2 (Re.ap x) (Im.ap x))));
  intros;
  Refine eq_cplx_intro;
  Refine Eq_refl (MinusR.ap2 (SquareR.ap (Re.ap x)) (SquareR.ap (Im.ap x)));
  Refine exten2 PlusR ?.Eq_refl; Refine TimesR_commut;
Save SquareC_elim;

(*
    re(x) + im(x) i  =  x
*)

Goal {x:el Cplx} Eq (PlusC.ap2 (Cp.ap (Re.ap x)) (Cpi.ap (Im.ap x))) x;
  intros;
  Refine eq_cplx_intro; Refine rZeroR_ident; Refine lZeroR_ident;
Save Cplx_lemma1;

(*   2
    i   =  -1
*)

Goal Eq (SquareC.ap I) (NegC.ap OneC);
  Refine eq_cplx_intro;
  Equiv Eq (MinusR.ap2 (SquareR.ap ZeroR) (SquareR.ap OneR)) (NegR.ap OneR);
  Refine Eq_trans (MinusR.ap2 ZeroR OneR);
    Refine exten2; Refine rTimesZeroR; Refine rOneR_ident;
    Refine lZeroR_ident;
  Equiv Eq (PlusR.ap2 (TimesR.ap2 ZeroR OneR) (TimesR.ap2 OneR ZeroR)) (NegR.ap ZeroR);
  Refine Eq_trans (PlusR.ap2 ZeroR ZeroR);
    Refine exten2; Refine lTimesZeroR; Refine rTimesZeroR;
  Refine Eq_trans ZeroR;
    Refine lZeroR_ident;
    Refine Eq_sym; Refine NegZeroR;
Save I_square;

(*
     i != 0
*)

Goal ~(Eq I ZeroC);
  Intros _; Refine Real_non_trivial; Refine Eq_sym; Refine (eq_cplx_elim H).snd;
Save I_not_zero;

(* --------------------------------------------------------------------------------
   Show that the negation is a group endomorphism on the complex numbers.
*)

Goal NegC_homoGr : Endomorphism COMPLEX_Group;
  Refine NegRg_homoGr COMPLEX_Ring;
Save;

Goal Injection NegC;
  Intros ___;
  Refine eq_cplx_elim H; intros;
  Refine eq_cplx_intro; Refine NegR_inj H1; Refine NegR_inj H2;
Save NegC_inj;

Goal Eq (NegC.ap ZeroC) ZeroC;
  Refine HomoGr_one NegC_homoGr;
Save NegC_zero;

Goal {x|el Cplx} ~(Eq x ZeroC) -> ~(Eq (NegC.ap x) ZeroC);
  Refine HomoGr_not_one NegC_homoGr NegC_inj;
Save NegC_not_zero;

(* --------------------------------------------------------------------------------
   Show Re is a group homomorphism from the complex to the real numbers.
*)

Goal {x,y:el Cplx} Eq (Re.ap (PlusC.ap2 x y)) (PlusR.ap2 (Re.ap x) (Re.ap y));
  intros;
  Refine Eq_refl;
Save Re_plus;

Goal Re_homoGr : Homomorphism COMPLEX_Group REAL_Group;
  Refine HomomorphismGr_intro;
  Refine Re;
  Refine Re_plus;
Save;

Goal Re_zero : Eq (Re.ap ZeroC) ZeroR;
  Refine HomoGr_one Re_homoGr;
Save;

Goal Re_neg : {x:el Cplx} Eq (Re.ap (NegC.ap x)) (NegR.ap (Re.ap x));
  Refine HomoGr_inv Re_homoGr;
Save;

(* --------------------------------------------------------------------------------
   Show Im is a group homomorphism from the complex to the real numbers.
*)

Goal {x,y:el Cplx} Eq (Im.ap (PlusC.ap2 x y)) (PlusR.ap2 (Im.ap x) (Im.ap y));
  intros;
  Refine Eq_refl;
Save Im_plus;

Goal Im_homoGr : Homomorphism COMPLEX_Group REAL_Group;
  Refine HomomorphismGr_intro;
  Refine Im;
  Refine Im_plus;
Save;

Goal Im_zero : Eq (Im.ap ZeroC) ZeroR;
  Refine HomoGr_one Im_homoGr;
Save;

Goal Im_neg : {x:el Cplx} Eq (Im.ap (NegC.ap x)) (NegR.ap (Im.ap x));
  Refine HomoGr_inv Im_homoGr;
Save;

(* --------------------------------------------------------------------------------
   Show Cp is a group homomorphism from the real to the complex numbers.
*)

Goal {x,y:el Real} Eq (Cp.ap (PlusR.ap2 x y)) (PlusC.ap2 (Cp.ap x) (Cp.ap y));
  intros;
  Refine eq_cplx_intro;
  Refine Eq_refl;
  Refine Eq_sym; Refine rZeroR_ident;
Save Cp_plus;

Goal Cp_homoGr : Homomorphism REAL_Group COMPLEX_Group;
  Refine HomomorphismGr_intro;
  Refine Cp;
  Refine Cp_plus;
Save;

(* --------------------------------------------------------------------------------
   Show Cp is a ring homomorphism from the real to the complex numbers.
*)

Goal Eq (Cp.ap OneR) OneC;
  Refine Eq_refl;
Save Cp_one;

Goal {x,y:el Real} Eq (Cp.ap (TimesR.ap2 x y)) (TimesC.ap2 (Cp.ap x) (Cp.ap y));
  intros;
  Refine eq_cplx_intro;
  Refine Eq_trans (MinusR.ap2 (TimesR.ap2 x y) ZeroR);
    Refine Eq_sym; Refine rNegZeroR_ident;
  Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine rTimesZeroR;
  Refine Eq_trans (PlusR.ap2 ZeroR ZeroR);
    Refine Eq_sym; Refine rZeroR_ident;
  Refine Eq_sym; Refine exten2; Refine rTimesZeroR; Refine lTimesZeroR;
Save Cp_times;

Goal Cp_homoRg : Homomorphism REAL_Ring COMPLEX_Ring;
  Refine HomomorphismRg_intro;
  Refine Cp;
  Refine Cp_one;
  Refine Cp_plus;
  Refine Cp_times;
Save;

Goal Cp_zero : Eq (Cp.ap ZeroR) ZeroC;
  Refine HomoRg_zero Cp_homoRg;
Save;

Goal Cp_neg : {x:el Real} Eq (Cp.ap (NegR.ap x)) (NegC.ap (Cp.ap x));
  Refine HomoRg_neg Cp_homoRg;
Save;

Goal Cp_power : {x:el Real}{n:el Nat}
                Eq (Cp.ap (PowerR.ap2 x n)) (PowerC.ap2 (Cp.ap x) n);
  Refine HomoRg_power Cp_homoRg;
Save;

(* --------------------------------------------------------------------------------
   Show Cp is a field homomorphism from real to the complex numbers.
*)

Goal Cp_homoFd : Homomorphism REAL_Ring COMPLEX_Ring;
  Refine HomomorphismFd_intro;
  Refine Cp;
  Refine Cp_one;
  Refine Cp_plus;
  Refine Cp_times;
Save;

Goal Cp_not_zero : {x|el Real} ~(Eq x ZeroR) -> ~(Eq (Cp.ap x) ZeroC);
  Refine HomoFd_not_zero Cp_homoFd;
Save;

Goal Cp_recip : {x|el Real} ~(Eq x ZeroR) -> Eq (Cp.ap (RecipR.ap x)) 
                                                (RecipC.ap (Cp.ap x));
  Refine HomoFd_recip Cp_homoFd;
Save;

(* --------------------------------------------------------------------------------
   Show Cpi is a group homomorphism from the real to the complex numbers.
*)

Goal {x,y:el Real} Eq (Cpi.ap (PlusR.ap2 x y)) (PlusC.ap2 (Cpi.ap x) (Cpi.ap y));
  intros;
  Refine eq_cplx_intro;
  Refine Eq_sym; Refine rZeroR_ident;
  Refine Eq_refl;
Save Cpi_plus;

Goal Cpi_homoGr : Homomorphism REAL_Group COMPLEX_Group;
  Refine HomomorphismGr_intro;
  Refine Cpi;
  Refine Cpi_plus;
Save;

